/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.rudp;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.ByteBufferOutputStream;
import org.limewire.io.NetworkUtils;
import org.limewire.nio.NIODispatcher;
import org.limewire.nio.observer.ReadWriteObserver;
import org.limewire.rudp.MessageDispatcher;
import org.limewire.rudp.UDPService;
import org.limewire.rudp.messages.MessageFormatException;
import org.limewire.rudp.messages.RUDPMessage;
import org.limewire.rudp.messages.RUDPMessageFactory;
import org.limewire.rudp.messages.impl.DefaultMessageFactory;
import org.limewire.service.ErrorService;

public class DefaultUDPService
implements UDPService,
ReadWriteObserver {
    private static final Log LOG = LogFactory.getLog(DefaultUDPService.class);
    private RUDPMessageFactory factory = new DefaultMessageFactory();
    private DatagramChannel channel;
    private final List<SendBundle> OUTGOING_MSGS = new LinkedList<SendBundle>();
    private final ByteBuffer BUFFER;
    private final int BUFFER_SIZE = 2048;
    private final MessageDispatcher DISPATCHER;

    public DefaultUDPService(MessageDispatcher messageDispatcher) {
        byte[] byArray = new byte[2048];
        this.BUFFER = ByteBuffer.wrap(byArray);
        this.DISPATCHER = messageDispatcher;
    }

    public int getStableListeningPort() {
        if (this.channel != null) {
            return this.channel.socket().getLocalPort();
        }
        return 0;
    }

    public InetAddress getStableListeningAddress() {
        if (this.channel != null) {
            return this.channel.socket().getLocalAddress();
        }
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public boolean isListening() {
        return this.channel != null;
    }

    public boolean isNATTraversalCapable() {
        return true;
    }

    public void start(int n) throws IOException {
        this.channel = this.getChannel(n);
        NIODispatcher.instance().registerReadWrite(this.channel, this);
    }

    public void shutdown() {
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private DatagramChannel getChannel(int n) throws IOException {
        DatagramChannel datagramChannel = DatagramChannel.open();
        datagramChannel.configureBlocking(false);
        DatagramSocket datagramSocket = datagramChannel.socket();
        datagramSocket.setReceiveBufferSize(65536);
        datagramSocket.setSendBufferSize(65536);
        datagramSocket.setReuseAddress(true);
        datagramSocket.bind(new InetSocketAddress(n));
        return datagramChannel;
    }

    public void handleIOException(IOException iOException) {
        if (!(iOException instanceof ClosedChannelException)) {
            ErrorService.error(iOException, "UDP Error.");
        } else {
            LOG.trace((Object)"Swallowing a UDPService ClosedChannelException", (Throwable)iOException);
        }
    }

    public void handleRead() throws IOException {
        while (true) {
            SocketAddress socketAddress;
            this.BUFFER.clear();
            try {
                socketAddress = this.channel.receive(this.BUFFER);
            }
            catch (IOException iOException) {
                break;
            }
            if (socketAddress == null) break;
            if (!(socketAddress instanceof InetSocketAddress)) {
                ErrorService.error(new IllegalStateException("non inet address"), "from: " + socketAddress);
                continue;
            }
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            if (!NetworkUtils.isValidAddress(inetSocketAddress.getAddress()) || !NetworkUtils.isValidPort(inetSocketAddress.getPort())) continue;
            this.BUFFER.flip();
            ByteBuffer byteBuffer = ByteBuffer.allocate(this.BUFFER.remaining());
            byteBuffer.put(this.BUFFER);
            byteBuffer.flip();
            RUDPMessage rUDPMessage = null;
            try {
                rUDPMessage = this.factory.createMessage(byteBuffer);
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            if (rUDPMessage == null) continue;
            this.processMessage(rUDPMessage, inetSocketAddress);
        }
    }

    protected void processMessage(RUDPMessage rUDPMessage, InetSocketAddress inetSocketAddress) {
        this.DISPATCHER.dispatch(rUDPMessage, inetSocketAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(RUDPMessage rUDPMessage, SocketAddress socketAddress) {
        if (rUDPMessage == null) {
            throw new IllegalArgumentException("Null Message");
        }
        if (socketAddress == null) {
            throw new IllegalArgumentException("Null InetAddress");
        }
        if (!NetworkUtils.isValidSocketAddress(socketAddress)) {
            throw new IllegalArgumentException("Invalid Port: " + socketAddress);
        }
        if (this.channel == null || this.channel.socket().isClosed()) {
            return;
        }
        ByteBufferOutputStream byteBufferOutputStream = new ByteBufferOutputStream();
        try {
            rUDPMessage.write(byteBufferOutputStream);
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
            return;
        }
        ByteBuffer byteBuffer = byteBufferOutputStream.getBuffer();
        byteBuffer.flip();
        List<SendBundle> list = this.OUTGOING_MSGS;
        synchronized (list) {
            this.OUTGOING_MSGS.add(new SendBundle(byteBuffer, socketAddress));
            if (this.channel != null) {
                NIODispatcher.instance().interestWrite(this.channel, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean handleWrite() throws IOException {
        List<SendBundle> list = this.OUTGOING_MSGS;
        synchronized (list) {
            while (true) {
                if (this.OUTGOING_MSGS.isEmpty()) {
                    NIODispatcher.instance().interestWrite(this.channel, false);
                    return false;
                }
                SendBundle sendBundle = this.OUTGOING_MSGS.remove(0);
                try {
                    if (this.channel.send(sendBundle.buffer, sendBundle.addr) != 0) continue;
                    this.OUTGOING_MSGS.add(0, sendBundle);
                    return true;
                }
                catch (IOException iOException) {
                    LOG.warn((Object)"Ignoring exception on socket", (Throwable)iOException);
                    continue;
                }
                break;
            }
        }
    }

    private static class SendBundle {
        private final ByteBuffer buffer;
        private final SocketAddress addr;

        SendBundle(ByteBuffer byteBuffer, SocketAddress socketAddress) {
            this.buffer = byteBuffer;
            this.addr = socketAddress;
        }
    }
}

