/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.rudp;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.LongHashMap;
import org.limewire.rudp.ChunkReleaser;
import org.limewire.rudp.DataRecord;
import org.limewire.rudp.messages.DataMessage;

public class DataWindow {
    private static final Log LOG = LogFactory.getLog(DataWindow.class);
    public static final int MAX_SEQUENCE_NUMBER = 65535;
    private static final int HIST_SIZE = 4;
    private static final float RTT_GAIN = 0.125f;
    private static final float DEVIATION_GAIN = 0.25f;
    private final LongHashMap<DataRecord> window;
    private long windowStart;
    private int windowSize;
    private long averageRTT;
    private long averageLowRTT;
    private int lowRTTCount;
    private float srtt;
    private float rttvar;
    private float rto;
    private boolean readableData;

    public DataWindow(int n, long l) {
        if (n < 1) {
            throw new IllegalArgumentException("size must be > 0");
        }
        this.windowStart = l;
        this.windowSize = n;
        this.window = new LongHashMap(n + 2);
    }

    public DataRecord addData(DataMessage dataMessage) {
        DataRecord dataRecord;
        if (this.windowStart > dataMessage.getSequenceNumber()) {
            throw new IllegalStateException("message is not in current window: " + this.windowStart + " > " + dataMessage.getSequenceNumber());
        }
        long l = dataMessage.getSequenceNumber();
        if (l == this.windowStart) {
            this.readableData = true;
        }
        if ((dataRecord = this.window.get(l)) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("received duplicate message seq: " + dataMessage.getSequenceNumber() + ", window start: " + this.windowStart));
            }
            return dataRecord;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("adding message seq: " + dataMessage.getSequenceNumber() + ", window start: " + this.windowStart));
        }
        dataRecord = new DataRecord(dataMessage);
        this.window.put(l, dataRecord);
        return dataRecord;
    }

    public DataRecord getBlock(long l) {
        return this.window.get(l);
    }

    public long getWindowStart() {
        return this.windowStart;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public int getUsedSpots() {
        int n = 0;
        for (long i = this.windowStart; i < this.windowStart + (long)this.windowSize + 3L; ++i) {
            DataRecord dataRecord = this.window.get(i);
            if (dataRecord == null || dataRecord.read && i == this.windowStart) continue;
            ++n;
        }
        return n;
    }

    public int getWindowSpace() {
        return this.windowSize - this.getUsedSpots();
    }

    public int clearLowAckedBlocks(ChunkReleaser chunkReleaser) {
        DataRecord dataRecord;
        int n = 0;
        for (long i = this.windowStart; i < this.windowStart + (long)this.windowSize + 1L && (dataRecord = this.window.get(i)) != null && dataRecord.acks > 0; ++i) {
            this.window.remove(i);
            ++n;
            if (chunkReleaser == null) continue;
            chunkReleaser.releaseChunk(dataRecord.msg.getChunk());
        }
        this.windowStart += (long)n;
        return n;
    }

    public long getLowestUnsentBlock() {
        for (long i = this.windowStart; i < this.windowStart + (long)this.windowSize + 1L; ++i) {
            if (this.window.get(i) != null) continue;
            return i;
        }
        return -1L;
    }

    public int countHigherAckBlocks() {
        int n = 0;
        for (long i = this.windowStart + 1L; i < this.windowStart + (long)this.windowSize + 1L; ++i) {
            DataRecord dataRecord = this.window.get(i);
            if (dataRecord == null || dataRecord.acks <= 0) continue;
            ++n;
        }
        return n;
    }

    public boolean acksAppearToBeMissing(long l, int n) {
        int n2 = (int)this.rto;
        DataRecord dataRecord = this.getBlock(this.windowStart);
        return n2 > 0 && dataRecord != null && dataRecord.acks < 1 && dataRecord.sentTime + (long)(n * n2) < l;
    }

    public int getRTO() {
        return (int)this.rto;
    }

    public float getRTTVar() {
        return this.rttvar;
    }

    public float getSRTT() {
        return this.srtt;
    }

    public int lowRoundTripTime() {
        return (int)this.averageLowRTT;
    }

    public void ackBlock(long l) {
        DataRecord dataRecord;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("entered ackBlock with # " + l));
        }
        if ((dataRecord = this.getBlock(l)) != null) {
            ++dataRecord.acks;
            dataRecord.ackTime = System.currentTimeMillis();
            if (dataRecord.acks == 1 && dataRecord.sends == 1) {
                long l2 = dataRecord.ackTime - dataRecord.sentTime;
                float f = (float)l2 - this.srtt;
                if (l2 > 0L) {
                    float f2;
                    this.srtt = (double)this.srtt <= 0.1 ? f : (this.srtt += 0.125f * f);
                    this.rttvar += 0.25f * (Math.abs(f) - this.rttvar);
                    this.rto = (float)((double)(this.srtt + 4.0f * this.rttvar) + 0.5);
                    if (this.averageRTT == 0L) {
                        this.averageRTT = l2;
                    } else {
                        f2 = (float)(this.averageRTT * 3L + l2) / 4.0f;
                        this.averageRTT = (long)f2;
                    }
                    if (this.lowRTTCount < 10 || l2 < this.averageLowRTT) {
                        if (this.averageLowRTT == 0L) {
                            this.averageLowRTT = l2;
                        } else {
                            f2 = (float)(this.averageLowRTT * 3L + l2) / 4.0f;
                            this.averageLowRTT = (long)f2;
                        }
                        ++this.lowRTTCount;
                    }
                }
            }
        }
    }

    public void pseudoAckToReceiverWindow(long l) {
        if (l <= this.windowStart) {
            return;
        }
        for (long i = this.windowStart; i < l; ++i) {
            DataRecord dataRecord = this.getBlock(i);
            if (dataRecord == null || dataRecord.acks != 0) continue;
            ++dataRecord.acks;
            dataRecord.ackTime = dataRecord.sentTime + (long)((int)this.rto);
        }
    }

    public DataRecord getOldestUnackedBlock() {
        DataRecord dataRecord = null;
        for (long i = this.windowStart; i < this.windowStart + (long)this.windowSize + 1L; ++i) {
            DataRecord dataRecord2 = this.getBlock(i);
            if (dataRecord2 == null || dataRecord2.acks != 0 || dataRecord != null && dataRecord2.sentTime >= dataRecord.sentTime) continue;
            dataRecord = dataRecord2;
        }
        return dataRecord;
    }

    public boolean hasReadableData() {
        return this.readableData;
    }

    public DataRecord getReadableBlock() {
        DataRecord dataRecord;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("wStart " + this.windowStart + " wSize " + this.windowSize));
        }
        for (long i = this.windowStart; i < this.windowStart + (long)this.windowSize + 1L && (dataRecord = this.getBlock(i)) != null; ++i) {
            if (dataRecord.read) continue;
            return dataRecord;
        }
        return null;
    }

    public int clearEarlyReadBlocks() {
        int n = 0;
        for (long i = this.windowStart; i < this.windowStart + (long)this.windowSize + 1L; ++i) {
            DataRecord dataRecord = this.window.get(i);
            if (dataRecord != null && dataRecord.read) {
                this.window.remove(i);
                ++n;
                continue;
            }
            if (dataRecord == null) {
                this.readableData = false;
                break;
            }
            this.readableData = true;
            break;
        }
        this.windowStart += (long)n;
        return n;
    }

    public int numNotRead() {
        int n = 0;
        for (long i = this.windowStart; i < this.windowStart + (long)this.windowSize + 1L; ++i) {
            DataRecord dataRecord = this.getBlock(i);
            if (dataRecord == null || dataRecord.read) continue;
            ++n;
        }
        return n;
    }
}

