/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio.timeout;

import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.Periodic;
import org.limewire.nio.observer.Shutdownable;

public final class StalledUploadWatchdog
extends Periodic {
    private static final Log LOG = LogFactory.getLog(StalledUploadWatchdog.class);
    public static long DELAY_TIME = 120000L;
    private final Closer closer = (Closer)this.getRunnable();
    private final long delayTime;

    public StalledUploadWatchdog(long l, ScheduledExecutorService scheduledExecutorService) {
        super(new Closer(), scheduledExecutorService);
        this.delayTime = l;
    }

    public boolean deactivate() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Deactivated on " + this.closer.shutdownable));
        }
        this.unschedule();
        this.closer.shutdownable = null;
        return this.closer.closed;
    }

    public synchronized void activate(Shutdownable shutdownable) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Activated on: " + shutdownable));
        }
        this.rescheduleIfLater(this.delayTime);
        this.closer.shutdownable = shutdownable;
    }

    private static class Closer
    implements Runnable {
        private volatile Shutdownable shutdownable;
        private volatile boolean closed;

        private Closer() {
        }

        public void run() {
            this.closed = true;
            Shutdownable shutdownable = this.shutdownable;
            if (shutdownable != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("STALLED!  Killing: " + shutdownable));
                }
                shutdownable.shutdown();
                this.shutdownable = null;
            }
        }
    }
}

