/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio.statemachine;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.nio.NIODispatcher;
import org.limewire.nio.channel.ChannelReadObserver;
import org.limewire.nio.channel.ChannelWriter;
import org.limewire.nio.channel.InterestReadableByteChannel;
import org.limewire.nio.channel.InterestScatteringByteChannel;
import org.limewire.nio.channel.InterestWritableByteChannel;
import org.limewire.nio.statemachine.IOState;
import org.limewire.nio.statemachine.IOStateObserver;
import org.limewire.util.BufferUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IOStateMachine
implements ChannelReadObserver,
ChannelWriter,
InterestScatteringByteChannel {
    private static final Log LOG = LogFactory.getLog(IOStateMachine.class);
    private IOStateObserver observer;
    private List<IOState> states;
    private IOState currentState;
    private volatile InterestWritableByteChannel writeSink;
    private volatile InterestReadableByteChannel readSink;
    private ByteBuffer readBuffer;
    private volatile boolean shutdown;

    public IOStateMachine(IOStateObserver iOStateObserver, List<IOState> list) {
        this(iOStateObserver, list, 2048);
    }

    public IOStateMachine(IOStateObserver iOStateObserver, List<IOState> list, int n) {
        this.observer = iOStateObserver;
        this.states = list;
        this.readBuffer = NIODispatcher.instance().getBufferCache().getHeap(n);
        if (!list.isEmpty()) {
            this.currentState = list.remove(0);
        }
    }

    public void addState(final IOState iOState) {
        NIODispatcher.instance().getScheduledExecutorService().execute(new Runnable(){

            public void run() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Adding single state: " + iOState));
                }
                IOStateMachine.this.states.add(iOState);
                if (IOStateMachine.this.states.size() == 1) {
                    IOStateMachine.this.nextState(false, false);
                }
            }
        });
    }

    public void addStates(final List<? extends IOState> list) {
        NIODispatcher.instance().getScheduledExecutorService().execute(new Runnable(){

            public void run() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Adding multiple states: " + list));
                }
                IOStateMachine.this.states.addAll(list);
                if (IOStateMachine.this.states.size() == list.size()) {
                    IOStateMachine.this.nextState(false, false);
                }
            }
        });
    }

    public void addStates(final IOState ... iOStateArray) {
        NIODispatcher.instance().getScheduledExecutorService().execute(new Runnable(){

            public void run() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Adding multiple states...");
                }
                for (int i = 0; i < iOStateArray.length; ++i) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(" state[" + i + "]: " + iOStateArray[i]));
                    }
                    IOStateMachine.this.states.add(iOStateArray[i]);
                }
                if (IOStateMachine.this.states.size() == iOStateArray.length) {
                    IOStateMachine.this.nextState(false, false);
                }
            }
        });
    }

    @Override
    public void handleRead() {
        if (this.currentState != null) {
            if (this.currentState.isWriting()) {
                LOG.warn((Object)"Got a read notification while writing.");
                this.processCurrentState(null, true);
                this.readSink.interestRead(false);
            } else {
                this.processCurrentState(this.currentState, true);
            }
        } else {
            LOG.warn((Object)"Got a read notification with no current state");
            this.processCurrentState(null, true);
            this.readSink.interestRead(false);
        }
    }

    @Override
    public boolean handleWrite() {
        if (this.currentState != null) {
            if (this.currentState.isReading()) {
                LOG.warn((Object)"Got a write notification while reading");
                this.writeSink.interestWrite(this, false);
                return false;
            }
            return this.processCurrentState(this.currentState, false);
        }
        LOG.warn((Object)"Got a write notification with no current state");
        this.writeSink.interestWrite(this, false);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processCurrentState(IOState iOState, boolean bl) {
        block19: {
            if (!this.shutdown) {
                try {
                    if (bl) {
                        if (iOState == null) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)"Processing a read with no state");
                            }
                            int n = 0;
                            while (this.readBuffer.hasRemaining() && (n = this.readSink.read(this.readBuffer)) > 0) {
                            }
                            if (this.readBuffer.position() == 0 && n == -1) {
                                throw new ClosedChannelException();
                            }
                        } else if (!iOState.process(this.readSink, this.readBuffer)) {
                            this.nextState(true, false);
                        }
                        break block19;
                    }
                    if (!iOState.process(this.writeSink, null)) {
                        this.nextState(false, true);
                        break block19;
                    }
                    return true;
                }
                catch (IOException iOException) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn((Object)("IOX while processing state: " + iOState), (Throwable)iOException);
                    }
                    IOStateMachine iOStateMachine = this;
                    synchronized (iOStateMachine) {
                        this.shutdown = true;
                    }
                    try {
                        this.close();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    NIODispatcher.instance().getBufferCache().release(this.readBuffer);
                    this.observer.handleIOException(iOException);
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Ignoring processing because machine is shutdown");
            }
        }
        return false;
    }

    private void nextState(boolean bl, boolean bl2) {
        if (this.states.isEmpty()) {
            LOG.debug((Object)"No more states, processing finished.");
            this.readSink.interestRead(false);
            this.writeSink.interestWrite(this, false);
            this.observer.handleStatesFinished();
        } else {
            this.currentState = this.states.remove(0);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Incrementing state to: " + this.currentState));
            }
            if (this.currentState.isReading() && !bl) {
                this.writeSink.interestWrite(this, false);
                if (this.readSink != null) {
                    this.readSink.interestRead(true);
                }
            }
            if (this.currentState.isWriting() && !bl2) {
                this.readSink.interestRead(false);
                if (this.writeSink != null) {
                    this.writeSink.interestWrite(this, true);
                }
            }
            if (this.currentState.isReading()) {
                this.processCurrentState(this.currentState, true);
            }
        }
    }

    @Override
    public InterestWritableByteChannel getWriteChannel() {
        return this.writeSink;
    }

    @Override
    public void setWriteChannel(InterestWritableByteChannel interestWritableByteChannel) {
        this.writeSink = interestWritableByteChannel;
        if (this.currentState != null) {
            this.writeSink.interestWrite(this, true);
        }
    }

    @Override
    public InterestReadableByteChannel getReadChannel() {
        return this.readSink;
    }

    @Override
    public void setReadChannel(InterestReadableByteChannel interestReadableByteChannel) {
        this.readSink = interestReadableByteChannel;
        if (this.currentState != null) {
            this.readSink.interestRead(true);
        }
    }

    @Override
    public boolean isOpen() {
        return this.readSink != null && this.readSink.isOpen() && this.writeSink != null && this.writeSink.isOpen();
    }

    @Override
    public void close() throws IOException {
        if (this.readSink != null) {
            this.readSink.close();
        }
        if (this.writeSink != null) {
            this.writeSink.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        IOStateMachine iOStateMachine = this;
        synchronized (iOStateMachine) {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
        }
        if (!this.isOpen()) {
            this.observer.shutdown();
        }
        NIODispatcher.instance().getScheduledExecutorService().execute(new Runnable(){

            public void run() {
                NIODispatcher.instance().getBufferCache().release(IOStateMachine.this.readBuffer);
            }
        });
    }

    @Override
    public void interestRead(boolean bl) {
        if (this.currentState != null) {
            this.readSink.interestRead(bl);
        }
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws ClosedChannelException {
        if (this.shutdown) {
            throw new ClosedChannelException();
        }
        return BufferUtils.transfer(this.readBuffer, byteBuffer);
    }

    @Override
    public long read(ByteBuffer[] byteBufferArray) throws ClosedChannelException {
        return this.read(byteBufferArray, 0, byteBufferArray.length);
    }

    @Override
    public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws ClosedChannelException {
        if (this.shutdown) {
            throw new ClosedChannelException();
        }
        return BufferUtils.transfer(this.readBuffer, byteBufferArray, 0, byteBufferArray.length, true);
    }

    @Override
    public void handleIOException(IOException iOException) {
    }
}

