/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio.statemachine;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.nio.NIODispatcher;
import org.limewire.nio.observer.Shutdownable;
import org.limewire.nio.statemachine.IOState;
import org.limewire.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockingStateMachine
implements Closeable,
Shutdownable {
    private static final Log LOG = LogFactory.getLog(BlockingStateMachine.class);
    private final List<IOState> states;
    private final ReadableByteChannel readChannel;
    private final WritableByteChannel writeChannel;
    private final ByteBuffer readBuffer;

    public BlockingStateMachine(List<IOState> list, InputStream inputStream, OutputStream outputStream) {
        this(list, 2048, inputStream, outputStream);
    }

    public BlockingStateMachine(List<IOState> list, int n, InputStream inputStream, OutputStream outputStream) {
        this.states = list;
        this.readBuffer = NIODispatcher.instance().getBufferCache().getHeap(n);
        this.readChannel = Channels.newChannel(inputStream);
        this.writeChannel = Channels.newChannel(outputStream);
    }

    public void addState(IOState iOState) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Adding single state: " + iOState));
        }
        this.states.add(iOState);
    }

    public void addStates(List<? extends IOState> list) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Adding multiple states: " + list));
        }
        this.states.addAll(list);
    }

    public void addStates(IOState ... iOStateArray) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Adding multiple states...");
        }
        for (int i = 0; i < iOStateArray.length; ++i) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(" state[" + i + "]: " + iOStateArray[i]));
            }
            this.states.add(iOStateArray[i]);
        }
    }

    @Override
    public void close() {
        FileUtils.close(this.readChannel);
        FileUtils.close(this.writeChannel);
    }

    @Override
    public void shutdown() {
        NIODispatcher.instance().getBufferCache().release(this.readBuffer);
    }

    public void process() throws IOException {
        Iterator<IOState> iterator = this.states.iterator();
        while (iterator.hasNext()) {
            IOState iOState = iterator.next();
            if (iOState.isReading()) {
                iOState.process(this.readChannel, this.readBuffer);
            } else if (iOState.isWriting()) {
                iOState.process(this.writeChannel, null);
            } else {
                throw new IllegalStateException("expected reading | writing state");
            }
            iterator.remove();
        }
    }
}

