/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio.ssl;

import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.nio.ByteBufferCache;
import org.limewire.util.BufferUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSLEngineTest {
    private static final Log LOG = LogFactory.getLog(SSLEngineTest.class);
    private final SSLContext context;
    private final String[] cipherSuites;
    private final ByteBufferCache cache;
    private Throwable lastFailureCause;

    public SSLEngineTest(SSLContext sSLContext, String[] stringArray, ByteBufferCache byteBufferCache) {
        this.context = sSLContext;
        this.cipherSuites = stringArray;
        this.cache = byteBufferCache;
    }

    public boolean go() {
        try {
            this.goImpl();
            return true;
        }
        catch (Throwable throwable) {
            LOG.error((Object)"Error in TLS!", throwable);
            this.lastFailureCause = throwable;
            return false;
        }
    }

    public Throwable getLastFailureCause() {
        return this.lastFailureCause;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void goImpl() throws SSLException {
        SSLEngine sSLEngine = this.context.createSSLEngine();
        SSLEngine sSLEngine2 = this.context.createSSLEngine();
        sSLEngine.setEnabledCipherSuites(this.cipherSuites);
        sSLEngine2.setEnabledCipherSuites(this.cipherSuites);
        sSLEngine.setUseClientMode(false);
        sSLEngine2.setUseClientMode(true);
        sSLEngine.setNeedClientAuth(false);
        sSLEngine.setWantClientAuth(false);
        SSLSession sSLSession = sSLEngine.getSession();
        ByteBuffer byteBuffer = this.cache.getHeap(sSLSession.getPacketBufferSize());
        ByteBuffer byteBuffer2 = this.cache.getHeap(sSLSession.getPacketBufferSize());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Starting handshake loop.\nServer: " + sSLEngine + "\nClient: " + sSLEngine2));
        }
        try {
            this.doHandshake(sSLEngine2, sSLEngine, byteBuffer, byteBuffer2);
            this.doData(sSLEngine2, sSLEngine, byteBuffer, byteBuffer2);
        }
        finally {
            this.cache.release(byteBuffer);
            this.cache.release(byteBuffer2);
        }
    }

    private void doHandshake(SSLEngine sSLEngine, SSLEngine sSLEngine2, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws SSLException {
        SSLEngineResult.HandshakeStatus handshakeStatus;
        SSLEngineResult.HandshakeStatus handshakeStatus2;
        SSLEngineResult sSLEngineResult = new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_WRAP, 0, 0);
        SSLEngineResult sSLEngineResult2 = new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_UNWRAP, 0, 0);
        do {
            LOG.debug((Object)"Processing client handshake loop");
            byteBuffer2.flip();
            sSLEngineResult = this.handshakeLoop(sSLEngineResult, sSLEngine, byteBuffer2, byteBuffer);
            byteBuffer2.compact();
            LOG.debug((Object)"Processing server handshake loop");
            byteBuffer.flip();
            sSLEngineResult2 = this.handshakeLoop(sSLEngineResult2, sSLEngine2, byteBuffer, byteBuffer2);
            byteBuffer.compact();
            handshakeStatus2 = sSLEngineResult.getHandshakeStatus();
            handshakeStatus = sSLEngineResult2.getHandshakeStatus();
        } while (handshakeStatus2 != SSLEngineResult.HandshakeStatus.FINISHED && handshakeStatus2 != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING || handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED && handshakeStatus != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING);
    }

    private SSLEngineResult handshakeLoop(SSLEngineResult sSLEngineResult, SSLEngine sSLEngine, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws SSLException {
        while (true) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Processing result: " + sSLEngineResult + ", from engine: " + sSLEngine + ", src: " + byteBuffer + ", dst: " + byteBuffer2));
            }
            if (sSLEngineResult.getStatus() != SSLEngineResult.Status.OK) {
                throw new IllegalStateException("Invalid result status: " + sSLEngineResult);
            }
            switch (sSLEngineResult.getHandshakeStatus()) {
                case FINISHED: 
                case NOT_HANDSHAKING: {
                    return sSLEngineResult;
                }
                case NEED_UNWRAP: {
                    if (!byteBuffer.hasRemaining()) {
                        return sSLEngineResult;
                    }
                    sSLEngineResult = sSLEngine.unwrap(byteBuffer, byteBuffer2);
                    break;
                }
                case NEED_TASK: {
                    Runnable runnable = sSLEngine.getDelegatedTask();
                    runnable.run();
                    sSLEngineResult = new SSLEngineResult(SSLEngineResult.Status.OK, sSLEngine.getHandshakeStatus(), 0, 0);
                    break;
                }
                case NEED_WRAP: {
                    if (byteBuffer2.position() != 0) {
                        return sSLEngineResult;
                    }
                    sSLEngineResult = sSLEngine.wrap(BufferUtils.getEmptyBuffer(), byteBuffer2);
                }
            }
        }
    }

    private void doData(SSLEngine sSLEngine, SSLEngine sSLEngine2, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws SSLException {
        LOG.debug((Object)"Doing client -> server data test");
        this.doDataTest("CLIENT TEST OUT", sSLEngine, sSLEngine2, byteBuffer, byteBuffer2);
        LOG.debug((Object)"Doing server -> client data test");
        this.doDataTest("SERVER TEST OUT", sSLEngine2, sSLEngine, byteBuffer2, byteBuffer);
        LOG.debug((Object)"Finished data test");
    }

    private void doDataTest(String string, SSLEngine sSLEngine, SSLEngine sSLEngine2, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws SSLException {
        ByteBuffer byteBuffer3 = ByteBuffer.wrap(string.getBytes());
        SSLEngineResult sSLEngineResult = sSLEngine.wrap(byteBuffer3, byteBuffer);
        if (sSLEngineResult.getStatus() != SSLEngineResult.Status.OK) {
            throw new IllegalStateException("Can't wrap data: " + sSLEngineResult);
        }
        if (byteBuffer3.hasRemaining()) {
            throw new IllegalStateException("Didn't wrap all data (" + string + "): " + byteBuffer3);
        }
        byteBuffer.flip();
        sSLEngineResult = sSLEngine2.unwrap(byteBuffer, byteBuffer2);
        if (sSLEngineResult.getStatus() != SSLEngineResult.Status.OK) {
            throw new IllegalStateException("Can't unwrap data: " + sSLEngineResult);
        }
        if (byteBuffer.hasRemaining()) {
            throw new IllegalStateException("Didn't unwrap all data!  readIn: " + byteBuffer + ", made: " + byteBuffer2);
        }
        String string2 = new String(byteBuffer2.array(), 0, byteBuffer2.position());
        if (!string.equals(string2)) {
            throw new IllegalStateException("Wrong data read!  Wanted: " + string + ", was: " + string2);
        }
        byteBuffer2.clear();
        byteBuffer.clear();
    }

    public boolean isIgnorable(Throwable throwable) {
        if (this.causeIs(throwable, NoSuchAlgorithmException.class)) {
            return true;
        }
        if (throwable instanceof NoSuchMethodError) {
            return true;
        }
        if (throwable instanceof NoClassDefFoundError) {
            return true;
        }
        String string = throwable.getMessage();
        return string != null && string.contains("Cipher buffering error");
    }

    private boolean causeIs(Throwable throwable, Class<? extends Throwable> clazz) {
        while (throwable != null) {
            if (clazz.isAssignableFrom(throwable.getClass())) {
                return true;
            }
            throwable = throwable.getCause();
        }
        return false;
    }
}

