/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio.channel;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.limewire.nio.NIODispatcher;
import org.limewire.nio.RequiresSelectionKeyAttachment;
import org.limewire.nio.Throttle;
import org.limewire.nio.ThrottleListener;
import org.limewire.nio.channel.ChannelWriter;
import org.limewire.nio.channel.InterestWritableByteChannel;
import org.limewire.nio.observer.WriteObserver;

public class ThrottleWriter
implements ChannelWriter,
InterestWritableByteChannel,
RequiresSelectionKeyAttachment {
    private volatile InterestWritableByteChannel channel;
    private volatile WriteObserver observer;
    private volatile Throttle throttle;
    private int available;
    private boolean channelInterested;
    private final Listener throttleListener;

    public ThrottleWriter(Throttle throttle) {
        this(throttle, null);
    }

    public ThrottleWriter(Throttle throttle, InterestWritableByteChannel interestWritableByteChannel) {
        this.throttle = throttle;
        this.channel = interestWritableByteChannel;
        this.throttleListener = new Listener();
    }

    public InterestWritableByteChannel getWriteChannel() {
        return this.channel;
    }

    public void setWriteChannel(InterestWritableByteChannel interestWritableByteChannel) {
        this.channel = interestWritableByteChannel;
        Throttle throttle = this.throttle;
        if (throttle != null) {
            throttle.interest(this.throttleListener);
        } else if (interestWritableByteChannel != null) {
            interestWritableByteChannel.interestWrite(this, true);
        }
    }

    public void interestWrite(WriteObserver writeObserver, boolean bl) {
        if (bl) {
            this.observer = writeObserver;
            if (this.channel != null) {
                Throttle throttle = this.throttle;
                if (throttle != null) {
                    throttle.interest(this.throttleListener);
                } else {
                    this.channel.interestWrite(this, bl);
                }
            }
        } else {
            this.observer = null;
        }
    }

    public int write(ByteBuffer byteBuffer) throws IOException {
        InterestWritableByteChannel interestWritableByteChannel = this.channel;
        if (interestWritableByteChannel == null) {
            throw new IllegalStateException("writing with no chain!");
        }
        if (this.throttle == null) {
            return interestWritableByteChannel.write(byteBuffer);
        }
        if (this.available == 0) {
            return 0;
        }
        int n = byteBuffer.limit();
        if (byteBuffer.remaining() > this.available) {
            byteBuffer.limit(byteBuffer.position() + this.available);
        }
        int n2 = this.channel.write(byteBuffer);
        this.available -= n2;
        byteBuffer.limit(n);
        return n2;
    }

    public void close() throws IOException {
        InterestWritableByteChannel interestWritableByteChannel = this.channel;
        if (interestWritableByteChannel != null) {
            interestWritableByteChannel.close();
        }
    }

    public boolean isOpen() {
        InterestWritableByteChannel interestWritableByteChannel = this.channel;
        return interestWritableByteChannel != null ? interestWritableByteChannel.isOpen() : false;
    }

    public boolean handleWrite() throws IOException {
        InterestWritableByteChannel interestWritableByteChannel = this.channel;
        if (interestWritableByteChannel == null) {
            throw new IllegalStateException("writing with no source.");
        }
        WriteObserver writeObserver = this.observer;
        interestWritableByteChannel.interestWrite(this, false);
        this.channelInterested = false;
        if (this.available > 0 || this.throttle == null) {
            if (writeObserver != null) {
                writeObserver.handleWrite();
            }
            writeObserver = this.observer;
        }
        if (writeObserver != null) {
            if (this.throttle != null) {
                this.throttle.interest(this.throttleListener);
            } else {
                interestWritableByteChannel.interestWrite(this, true);
            }
            return true;
        }
        return false;
    }

    public void shutdown() {
        WriteObserver writeObserver = this.observer;
        if (writeObserver != null) {
            writeObserver.shutdown();
        }
    }

    public void handleIOException(IOException iOException) {
        throw new RuntimeException("Unsupported", iOException);
    }

    public boolean hasBufferedOutput() {
        InterestWritableByteChannel interestWritableByteChannel = this.channel;
        return interestWritableByteChannel != null && interestWritableByteChannel.hasBufferedOutput();
    }

    public void setThrottle(final Throttle throttle) {
        NIODispatcher.instance().getScheduledExecutorService().execute(new Runnable(){

            public void run() {
                ThrottleWriter.this.setThrottleInternal(throttle);
            }
        });
    }

    protected void setThrottleInternal(Throttle throttle) {
        this.throttleListener.releaseBandwidth();
        this.throttle = throttle;
        if (throttle != null) {
            throttle.interest(this.throttleListener);
        } else if (this.channel != null) {
            this.channel.interestWrite(this, true);
        }
    }

    public void setAttachment(Object object) {
        this.throttleListener.setAttachment(object);
    }

    private final class Listener
    implements ThrottleListener {
        private Object attachment;

        private Listener() {
        }

        public boolean bandwidthAvailable() {
            if (ThrottleWriter.this.channel.isOpen()) {
                if (!ThrottleWriter.this.channelInterested) {
                    ThrottleWriter.this.channelInterested = true;
                    ThrottleWriter.this.channel.interestWrite(ThrottleWriter.this, true);
                }
                return true;
            }
            return false;
        }

        public boolean isOpen() {
            return ThrottleWriter.this.isOpen();
        }

        public void requestBandwidth() {
            if (ThrottleWriter.this.throttle != null) {
                ThrottleWriter.this.available = ThrottleWriter.this.throttle.request();
            }
        }

        public void releaseBandwidth() {
            if (ThrottleWriter.this.throttle != null) {
                ThrottleWriter.this.throttle.release(ThrottleWriter.this.available);
                ThrottleWriter.this.available = 0;
            }
        }

        public void setAttachment(Object object) {
            this.attachment = object;
        }

        public Object getAttachment() {
            return this.attachment;
        }
    }
}

