/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio.channel;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.limewire.nio.RequiresSelectionKeyAttachment;
import org.limewire.nio.Throttle;
import org.limewire.nio.ThrottleListener;
import org.limewire.nio.channel.ChannelReader;
import org.limewire.nio.channel.InterestReadableByteChannel;
import org.limewire.util.BufferUtils;

public class ThrottleReader
implements InterestReadableByteChannel,
ChannelReader,
RequiresSelectionKeyAttachment {
    private volatile InterestReadableByteChannel channel;
    private final Throttle throttle;
    private int available;
    private volatile boolean lastInterestState;
    private final Listener throttleListener;

    public ThrottleReader(Throttle throttle) {
        this(throttle, null);
    }

    public ThrottleReader(Throttle throttle, InterestReadableByteChannel interestReadableByteChannel) {
        this.throttle = throttle;
        this.channel = interestReadableByteChannel;
        this.throttleListener = new Listener();
    }

    public InterestReadableByteChannel getReadChannel() {
        return this.channel;
    }

    public void setReadChannel(InterestReadableByteChannel interestReadableByteChannel) {
        this.channel = interestReadableByteChannel;
        this.throttle.interest(this.throttleListener);
    }

    public void interestRead(boolean bl) {
        this.lastInterestState = bl;
        if (this.channel != null) {
            if (bl) {
                this.throttle.interest(this.throttleListener);
            } else {
                this.channel.interestRead(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(ByteBuffer byteBuffer) throws IOException {
        InterestReadableByteChannel interestReadableByteChannel = this.channel;
        if (interestReadableByteChannel == null) {
            throw new IllegalStateException("reading with no chain!");
        }
        int n = 0;
        if (this.available > 0) {
            int n2 = byteBuffer.limit();
            if (byteBuffer.remaining() > this.available) {
                byteBuffer.limit(byteBuffer.position() + this.available);
            }
            try {
                n = this.channel.read(byteBuffer);
            }
            finally {
                byteBuffer.limit(n2);
            }
            if (n > 0) {
                this.available -= n;
            }
        } else {
            this.channel.read(BufferUtils.getEmptyBuffer());
            this.channel.interestRead(false);
            if (this.lastInterestState) {
                this.throttle.interest(this.throttleListener);
            }
        }
        return n;
    }

    public void close() throws IOException {
        InterestReadableByteChannel interestReadableByteChannel = this.channel;
        if (interestReadableByteChannel != null) {
            interestReadableByteChannel.close();
        }
    }

    public boolean isOpen() {
        InterestReadableByteChannel interestReadableByteChannel = this.channel;
        return interestReadableByteChannel != null ? interestReadableByteChannel.isOpen() : false;
    }

    public void setAttachment(Object object) {
        this.throttleListener.setAttachment(object);
    }

    private final class Listener
    implements ThrottleListener {
        private Object attachment;

        private Listener() {
        }

        public boolean bandwidthAvailable() {
            if (ThrottleReader.this.channel.isOpen() && ThrottleReader.this.lastInterestState) {
                ThrottleReader.this.channel.interestRead(true);
                return true;
            }
            return false;
        }

        public boolean isOpen() {
            return ThrottleReader.this.isOpen();
        }

        public void requestBandwidth() {
            ThrottleReader.this.available = ThrottleReader.this.throttle.request();
        }

        public void releaseBandwidth() {
            ThrottleReader.this.throttle.release(ThrottleReader.this.available);
            ThrottleReader.this.available = 0;
            if (ThrottleReader.this.lastInterestState) {
                ThrottleReader.this.throttle.interest(this);
            }
        }

        public void setAttachment(Object object) {
            this.attachment = object;
        }

        public Object getAttachment() {
            return this.attachment;
        }
    }
}

