/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio.channel;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import org.limewire.collection.Buffer;
import org.limewire.nio.channel.AbstractChannelInterestWriter;
import org.limewire.nio.observer.WriteObserver;
import org.limewire.util.ByteUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatisticGatheringWriter
extends AbstractChannelInterestWriter {
    private static final long NANO_START = System.nanoTime();
    private static final int HISTORY = 50;
    private final Buffer<Long> handleWrites = new Buffer(50);
    private final Buffer<Long> interestWrites = new Buffer(50);
    private final Buffer<Boolean> interestWritesStatus = new Buffer(50);
    private final Buffer<Long> writeTimes = new Buffer(50);
    private final Buffer<Long> writeAmounts = new Buffer(50);
    private final long msStart = System.currentTimeMillis();
    private long amountWrote;
    private long totalHandleWrite;
    private long totalInterestWrite;
    private long positiveInterestWrite;

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        this.writeTimes.add(System.nanoTime() - NANO_START);
        int n = super.write(byteBuffer);
        this.amountWrote += (long)n;
        this.writeAmounts.add(Long.valueOf(n));
        return n;
    }

    @Override
    public boolean handleWrite() throws IOException {
        this.handleWrites.add(System.nanoTime() - NANO_START);
        ++this.totalHandleWrite;
        return super.handleWrite();
    }

    @Override
    public void interestWrite(WriteObserver writeObserver, boolean bl) {
        this.interestWrites.add(System.nanoTime() - NANO_START);
        this.interestWritesStatus.add(bl);
        ++this.totalInterestWrite;
        if (bl) {
            ++this.positiveInterestWrite;
        }
        super.interestWrite(writeObserver, bl);
    }

    public Object inspect() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("ver", 1);
        hashMap.put("ms", this.msStart);
        hashMap.put("hw", this.getPacked(this.handleWrites));
        hashMap.put("iw", this.getPacked(this.interestWrites));
        hashMap.put("iws", this.getPackedBool(this.interestWritesStatus));
        hashMap.put("wt", this.getPacked(this.writeTimes));
        hashMap.put("wa", this.getPacked(this.writeAmounts));
        hashMap.put("totalWrote", this.amountWrote);
        hashMap.put("totalHW", this.totalHandleWrite);
        hashMap.put("totalIW", this.totalInterestWrite);
        hashMap.put("totalIWP", this.positiveInterestWrite);
        return hashMap;
    }

    private byte[] getPacked(Buffer<Long> buffer) {
        byte[] byArray = new byte[buffer.getSize() * 8];
        for (int i = 0; i < buffer.getSize(); ++i) {
            ByteUtils.long2beb(buffer.get(i), byArray, i * 8);
        }
        return byArray;
    }

    private byte[] getPackedBool(Buffer<Boolean> buffer) {
        byte[] byArray = new byte[buffer.getSize()];
        for (int i = 0; i < buffer.getSize(); ++i) {
            byArray[i] = (byte)(buffer.get(i) != false ? 1 : 0);
        }
        return byArray;
    }
}

