/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio.channel;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.limewire.nio.channel.ChannelReader;
import org.limewire.nio.channel.InterestReadableByteChannel;

public class InflaterReader
implements ChannelReader,
InterestReadableByteChannel {
    private Inflater inflater;
    private InterestReadableByteChannel channel;
    private ByteBuffer data;

    public InflaterReader(Inflater inflater) {
        this(null, inflater);
    }

    public InflaterReader(InterestReadableByteChannel interestReadableByteChannel, Inflater inflater) {
        if (inflater == null) {
            throw new NullPointerException("null inflater!");
        }
        this.channel = interestReadableByteChannel;
        this.inflater = inflater;
        this.data = ByteBuffer.allocate(512);
    }

    public void setReadChannel(InterestReadableByteChannel interestReadableByteChannel) {
        if (interestReadableByteChannel == null) {
            throw new NullPointerException("cannot set null channel!");
        }
        this.channel = interestReadableByteChannel;
    }

    public InterestReadableByteChannel getReadChannel() {
        return this.channel;
    }

    public void interestRead(boolean bl) {
        this.channel.interestRead(bl);
    }

    public int read(ByteBuffer byteBuffer) throws IOException {
        int n = 0;
        int n2 = 0;
        while (byteBuffer.hasRemaining()) {
            int n3 = this.inflate(byteBuffer);
            n += n3;
            if (n3 != 0) continue;
            if (this.inflater.finished() || this.inflater.needsDictionary()) {
                n2 = -1;
                break;
            }
            if (!this.inflater.needsInput()) continue;
            while (this.data.hasRemaining() && (n2 = this.channel.read(this.data)) > 0) {
            }
            if (this.data.position() == 0) break;
            this.inflater.setInput(this.data.array(), 0, this.data.position());
            this.data.clear();
        }
        if (n > 0) {
            return n;
        }
        if (n2 == -1) {
            return -1;
        }
        return 0;
    }

    private int inflate(ByteBuffer byteBuffer) throws IOException {
        int n = 0;
        int n2 = byteBuffer.position();
        try {
            n = this.inflater.inflate(byteBuffer.array(), n2, byteBuffer.remaining());
        }
        catch (DataFormatException dataFormatException) {
            IOException iOException = new IOException();
            iOException.initCause(dataFormatException);
            throw iOException;
        }
        catch (NullPointerException nullPointerException) {
            IOException iOException = new IOException();
            iOException.initCause(nullPointerException);
            throw iOException;
        }
        byteBuffer.position(n2 + n);
        return n;
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public void close() throws IOException {
        this.channel.close();
    }
}

