/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio.channel;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.Periodic;
import org.limewire.nio.NIODispatcher;
import org.limewire.nio.channel.ChannelWriter;
import org.limewire.nio.channel.InterestWritableByteChannel;
import org.limewire.nio.observer.WriteObserver;

public class DelayedBufferWriter
implements ChannelWriter,
InterestWritableByteChannel {
    private static final Log LOG = LogFactory.getLog(DelayedBufferWriter.class);
    private static final int DEFAULT_DELAY = 200;
    private volatile InterestWritableByteChannel sink;
    private volatile WriteObserver observer;
    private final ByteBuffer buf;
    private final long delay;
    private final Periodic interester;
    private long lastFlushTime;

    public DelayedBufferWriter(int n) {
        this(n, 200L);
    }

    public DelayedBufferWriter(int n, long l) {
        this(n, l, NIODispatcher.instance().getScheduledExecutorService());
    }

    DelayedBufferWriter(int n, long l, ScheduledExecutorService scheduledExecutorService) {
        this.buf = ByteBuffer.allocate(n);
        this.delay = TimeUnit.MILLISECONDS.toNanos(l);
        this.interester = new Periodic(new Interester(), scheduledExecutorService);
    }

    public synchronized void interestWrite(WriteObserver writeObserver, boolean bl) {
        if (bl) {
            this.observer = writeObserver;
            this.interester.unschedule();
            LOG.debug((Object)"cancelling scheduled flush");
        } else {
            this.observer = null;
        }
        InterestWritableByteChannel interestWritableByteChannel = this.sink;
        if (interestWritableByteChannel != null) {
            interestWritableByteChannel.interestWrite(this, true);
        }
    }

    public void close() throws IOException {
        InterestWritableByteChannel interestWritableByteChannel = this.sink;
        if (interestWritableByteChannel != null) {
            interestWritableByteChannel.close();
        }
    }

    public boolean isOpen() {
        InterestWritableByteChannel interestWritableByteChannel = this.sink;
        return interestWritableByteChannel != null ? interestWritableByteChannel.isOpen() : false;
    }

    public InterestWritableByteChannel getWriteChannel() {
        return this.sink;
    }

    public void setWriteChannel(InterestWritableByteChannel interestWritableByteChannel) {
        this.sink = interestWritableByteChannel;
        interestWritableByteChannel.interestWrite(this, true);
    }

    public void handleIOException(IOException iOException) {
        throw new RuntimeException("Unsupported", iOException);
    }

    public void shutdown() {
        WriteObserver writeObserver = this.observer;
        if (writeObserver != null) {
            writeObserver.shutdown();
        }
    }

    public int write(ByteBuffer byteBuffer) throws IOException {
        int n = byteBuffer.position();
        while (byteBuffer.hasRemaining()) {
            if (this.buf.hasRemaining()) {
                int n2;
                int n3 = this.buf.remaining();
                if (n3 >= (n2 = byteBuffer.remaining())) {
                    this.buf.put(byteBuffer);
                    continue;
                }
                int n4 = byteBuffer.limit();
                int n5 = byteBuffer.position();
                byteBuffer.limit(n5 + n3);
                this.buf.put(byteBuffer);
                byteBuffer.limit(n4);
                continue;
            }
            this.flush(System.nanoTime());
            if (this.buf.hasRemaining()) continue;
            break;
        }
        return byteBuffer.position() - n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleWrite() throws IOException {
        WriteObserver writeObserver = this.observer;
        if (writeObserver != null) {
            writeObserver.handleWrite();
        }
        long l = System.nanoTime();
        if (this.lastFlushTime == 0L) {
            this.lastFlushTime = l;
        }
        if (l - this.lastFlushTime > this.delay) {
            this.flush(l);
        }
        DelayedBufferWriter delayedBufferWriter = this;
        synchronized (delayedBufferWriter) {
            writeObserver = this.observer;
            if (writeObserver == null) {
                this.sink.interestWrite(this, false);
                if (!this.hasBufferedData()) {
                    return false;
                }
                this.interester.rescheduleIfLater(TimeUnit.NANOSECONDS.toMillis(this.lastFlushTime + this.delay - l));
            }
        }
        return true;
    }

    public boolean flush() throws IOException {
        this.flush(System.nanoTime());
        return !this.hasBufferedData();
    }

    private void flush(long l) throws IOException {
        this.buf.flip();
        InterestWritableByteChannel interestWritableByteChannel = this.sink;
        interestWritableByteChannel.write(this.buf);
        if (this.hasBufferedData()) {
            this.lastFlushTime = l;
            if (this.buf.hasRemaining()) {
                this.buf.compact();
            } else {
                this.buf.clear();
            }
        } else {
            this.buf.position(this.buf.limit()).limit(this.buf.capacity());
        }
    }

    private boolean hasBufferedData() {
        return this.buf.position() > 0;
    }

    public boolean hasBufferedOutput() {
        InterestWritableByteChannel interestWritableByteChannel = this.sink;
        return this.hasBufferedData() || interestWritableByteChannel != null && interestWritableByteChannel.hasBufferedOutput();
    }

    private class Interester
    implements Runnable {
        private Interester() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            DelayedBufferWriter delayedBufferWriter;
            DelayedBufferWriter delayedBufferWriter2 = delayedBufferWriter = DelayedBufferWriter.this;
            synchronized (delayedBufferWriter2) {
                InterestWritableByteChannel interestWritableByteChannel = delayedBufferWriter.sink;
                WriteObserver writeObserver = DelayedBufferWriter.this.observer;
                if (interestWritableByteChannel != null && interestWritableByteChannel.isOpen() && writeObserver == null && DelayedBufferWriter.this.buf.position() > 0) {
                    LOG.debug((Object)"forcing a flush");
                    interestWritableByteChannel.interestWrite(delayedBufferWriter, true);
                }
            }
        }
    }
}

