/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio.channel;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.limewire.nio.channel.ChannelReadObserver;
import org.limewire.nio.channel.InterestReadableByteChannel;
import org.limewire.nio.channel.InterestScatteringByteChannel;
import org.limewire.util.BufferUtils;

public abstract class AbstractChannelInterestReader
implements ChannelReadObserver,
InterestScatteringByteChannel {
    protected ByteBuffer buffer;
    protected InterestReadableByteChannel source;
    protected boolean shutdown;

    public AbstractChannelInterestReader(int n) {
        this.buffer = ByteBuffer.allocate(n);
    }

    public int read(ByteBuffer byteBuffer) {
        return BufferUtils.transfer(this.buffer, byteBuffer);
    }

    public long read(ByteBuffer[] byteBufferArray) {
        return this.read(byteBufferArray, 0, byteBufferArray.length);
    }

    public long read(ByteBuffer[] byteBufferArray, int n, int n2) {
        return BufferUtils.transfer(this.buffer, byteBufferArray, n, n2, true);
    }

    public void shutdown() {
        this.shutdown = true;
    }

    public InterestReadableByteChannel getReadChannel() {
        return this.source;
    }

    public void setReadChannel(InterestReadableByteChannel interestReadableByteChannel) {
        this.source = interestReadableByteChannel;
    }

    public void interestRead(boolean bl) {
        this.source.interestRead(bl);
    }

    public void close() throws IOException {
        this.source.close();
    }

    public boolean isOpen() {
        return this.source.isOpen();
    }

    public void handleIOException(IOException iOException) {
    }
}

