/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio;

import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ScheduledFutureTask<V>
extends FutureTask<V>
implements ScheduledFuture<V> {
    private static final long NANO_ORIGIN = System.nanoTime();
    private static final AtomicLong sequencer = new AtomicLong(0L);
    private final long sequenceNumber;
    private long time;

    ScheduledFutureTask(Runnable runnable, V v, long l) {
        super(runnable, v);
        this.time = l + this.now();
        this.sequenceNumber = sequencer.getAndIncrement();
    }

    ScheduledFutureTask(Callable<V> callable, long l) {
        super(callable);
        this.time = l + this.now();
        this.sequenceNumber = sequencer.getAndIncrement();
    }

    @Override
    public long getDelay(TimeUnit timeUnit) {
        long l = timeUnit.convert(this.time - this.now(), TimeUnit.NANOSECONDS);
        return l;
    }

    private final long now() {
        return System.nanoTime() - NANO_ORIGIN;
    }

    @Override
    public int compareTo(Delayed delayed) {
        if (delayed == this) {
            return 0;
        }
        ScheduledFutureTask scheduledFutureTask = (ScheduledFutureTask)delayed;
        long l = this.time - scheduledFutureTask.time;
        if (l < 0L) {
            return -1;
        }
        if (l > 0L) {
            return 1;
        }
        if (this.sequenceNumber < scheduledFutureTask.sequenceNumber) {
            return -1;
        }
        return 1;
    }
}

