/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.limewire.collection.IntHashMap;

public class HeapByteBufferCache {
    private static final int MAX_SIZE = 0x100000;
    private final IntHashMap<List<ByteBuffer>> CACHE = new IntHashMap();
    private long totalCacheSize;

    public ByteBuffer get() {
        return this.get(8192);
    }

    public synchronized ByteBuffer get(int n) {
        if (this.CACHE.isEmpty()) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(n);
            return byteBuffer;
        }
        List<ByteBuffer> list = this.CACHE.get(n);
        if (list != null && !list.isEmpty()) {
            ByteBuffer byteBuffer = list.remove(list.size() - 1);
            this.totalCacheSize -= (long)byteBuffer.capacity();
            return byteBuffer;
        }
        return ByteBuffer.allocate(n);
    }

    public synchronized void put(ByteBuffer byteBuffer) {
        if (this.totalCacheSize > 0x100000L) {
            return;
        }
        int n = byteBuffer.capacity();
        byteBuffer.clear();
        List<ByteBuffer> list = this.CACHE.get(n);
        if (list == null) {
            list = new ArrayList<ByteBuffer>(1);
            this.CACHE.put(n, list);
        }
        list.add(byteBuffer);
        this.totalCacheSize += (long)byteBuffer.capacity();
    }

    public synchronized void clear() {
        this.CACHE.clear();
        this.totalCacheSize = 0L;
    }

    public synchronized long getByteSize() {
        return this.totalCacheSize;
    }
}

