/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.nio.InterruptedIOException;
import org.limewire.nio.NBSocket;
import org.limewire.nio.NIODispatcher;
import org.limewire.nio.NIOInputStream;
import org.limewire.nio.NIOOutputStream;
import org.limewire.nio.NoOpReader;
import org.limewire.nio.NoOpWriter;
import org.limewire.nio.RequiresSelectionKeyAttachment;
import org.limewire.nio.channel.ChannelReadObserver;
import org.limewire.nio.channel.ChannelReader;
import org.limewire.nio.channel.ChannelWriter;
import org.limewire.nio.channel.InterestReadableByteChannel;
import org.limewire.nio.channel.InterestWritableByteChannel;
import org.limewire.nio.channel.NIOMultiplexor;
import org.limewire.nio.observer.ConnectObserver;
import org.limewire.nio.observer.ReadObserver;
import org.limewire.nio.observer.ReadWriteObserver;
import org.limewire.nio.observer.Shutdownable;
import org.limewire.nio.observer.WriteObserver;
import org.limewire.nio.timeout.ReadTimeout;
import org.limewire.nio.timeout.SoTimeout;
import org.limewire.util.VersionUtils;

public abstract class AbstractNBSocket
extends NBSocket
implements ConnectObserver,
ReadWriteObserver,
NIOMultiplexor,
ReadTimeout,
SoTimeout {
    private static final Log LOG = LogFactory.getLog(AbstractNBSocket.class);
    private final Object LOCK = new Object();
    private volatile ReadObserver reader;
    private volatile WriteObserver writer;
    private volatile NIOOutputStream nioOutputStream;
    private volatile ConnectObserver connecter;
    private volatile Shutdownable shutdownObserver;
    private boolean shutdown = false;

    protected abstract InterestReadableByteChannel getBaseReadChannel();

    protected abstract InterestWritableByteChannel getBaseWriteChannel();

    protected abstract void shutdownImpl();

    public final void setInitialReader() {
        this.reader = new NIOInputStream(this, this, this.getBaseReadChannel());
    }

    public final void setInitialWriter() {
        InterestWritableByteChannel interestWritableByteChannel = this.getBaseWriteChannel();
        this.writer = this.getBottomFromChain(interestWritableByteChannel);
        this.nioOutputStream = new NIOOutputStream(this, interestWritableByteChannel);
    }

    private InterestWritableByteChannel getBottomFromChain(InterestWritableByteChannel interestWritableByteChannel) {
        if (interestWritableByteChannel instanceof ChannelWriter) {
            ChannelWriter channelWriter = (ChannelWriter)((Object)interestWritableByteChannel);
            while (channelWriter.getWriteChannel() instanceof ChannelWriter) {
                channelWriter = (ChannelWriter)((Object)channelWriter.getWriteChannel());
            }
            return (InterestWritableByteChannel)((Object)channelWriter);
        }
        return interestWritableByteChannel;
    }

    public final void setShutdownObserver(Shutdownable shutdownable) {
        this.shutdownObserver = shutdownable;
    }

    public final void setReadObserver(final ChannelReadObserver channelReadObserver) {
        NIODispatcher.instance().getScheduledExecutorService().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ReadObserver readObserver = AbstractNBSocket.this.reader;
                try {
                    Object object = AbstractNBSocket.this.LOCK;
                    synchronized (object) {
                        if (AbstractNBSocket.this.shutdown) {
                            channelReadObserver.shutdown();
                            return;
                        }
                        AbstractNBSocket.this.reader = channelReadObserver;
                    }
                    object = channelReadObserver;
                    while (object.getReadChannel() instanceof ChannelReader) {
                        object = (ChannelReader)((Object)object.getReadChannel());
                    }
                    if (object instanceof RequiresSelectionKeyAttachment) {
                        ((RequiresSelectionKeyAttachment)object).setAttachment(AbstractNBSocket.this);
                    }
                    if (readObserver instanceof InterestReadableByteChannel && readObserver != channelReadObserver) {
                        object.setReadChannel((InterestReadableByteChannel)((Object)readObserver));
                        AbstractNBSocket.this.reader.handleRead();
                        readObserver.shutdown();
                    }
                    InterestReadableByteChannel interestReadableByteChannel = AbstractNBSocket.this.getBaseReadChannel();
                    object.setReadChannel(interestReadableByteChannel);
                    interestReadableByteChannel.interestRead(true);
                    if (AbstractNBSocket.this.isConnected() && !NIODispatcher.instance().isReadReadyThisIteration(AbstractNBSocket.this.getChannel())) {
                        AbstractNBSocket.this.reader.handleRead();
                    }
                }
                catch (IOException iOException) {
                    AbstractNBSocket.this.shutdown();
                    readObserver.shutdown();
                }
            }
        });
    }

    public final void setWriteObserver(final ChannelWriter channelWriter) {
        NIODispatcher.instance().getScheduledExecutorService().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    if (AbstractNBSocket.this.writer.handleWrite()) {
                        throw new IllegalStateException("data still in old writer!");
                    }
                    AbstractNBSocket.this.writer.shutdown();
                    if (AbstractNBSocket.this.nioOutputStream != null) {
                        AbstractNBSocket.this.nioOutputStream.shutdown();
                    }
                    ChannelWriter channelWriter2 = channelWriter;
                    while (channelWriter2.getWriteChannel() instanceof ChannelWriter) {
                        if (!((channelWriter2 = (ChannelWriter)((Object)channelWriter2.getWriteChannel())) instanceof RequiresSelectionKeyAttachment)) continue;
                        ((RequiresSelectionKeyAttachment)((Object)channelWriter2)).setAttachment(AbstractNBSocket.this);
                    }
                    InterestWritableByteChannel interestWritableByteChannel = AbstractNBSocket.this.getBaseWriteChannel();
                    Object object = AbstractNBSocket.this.LOCK;
                    synchronized (object) {
                        channelWriter2.setWriteChannel(interestWritableByteChannel);
                        if (AbstractNBSocket.this.shutdown) {
                            interestWritableByteChannel.shutdown();
                            return;
                        }
                        AbstractNBSocket.this.nioOutputStream = null;
                        AbstractNBSocket.this.writer = AbstractNBSocket.this.getBottomFromChain(interestWritableByteChannel);
                    }
                }
                catch (IOException iOException) {
                    AbstractNBSocket.this.shutdown();
                    channelWriter.shutdown();
                }
            }
        });
    }

    public final void handleConnect(Socket socket) throws IOException {
        ConnectObserver connectObserver = this.connecter;
        this.connecter = null;
        connectObserver.handleConnect(this);
    }

    public final void handleRead() throws IOException {
        this.reader.handleRead();
    }

    public final boolean handleWrite() throws IOException {
        return this.writer.handleWrite();
    }

    public final void close() {
        this.shutdown();
    }

    public final void connect(SocketAddress socketAddress) throws IOException {
        this.connect(socketAddress, 0);
    }

    public final void connect(SocketAddress socketAddress, int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException("timeout must not be < 0");
        }
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        ConnectObserver connectObserver = new ConnectObserver(){

            public void handleConnect(Socket socket) {
                countDownLatch.countDown();
            }

            public void shutdown() {
                countDownLatch.countDown();
            }

            public void handleIOException(IOException iOException) {
            }
        };
        if (!this.connect(socketAddress, n, connectObserver)) {
            long l = System.currentTimeMillis();
            try {
                if (n == 0) {
                    countDownLatch.await();
                } else {
                    countDownLatch.await(n + 1000, TimeUnit.MILLISECONDS);
                }
            }
            catch (InterruptedException interruptedException) {
                this.shutdown();
                throw new InterruptedIOException(interruptedException);
            }
            if (!this.isConnected()) {
                this.shutdown();
                long l2 = System.currentTimeMillis();
                if (n != 0 && l2 - l >= (long)n) {
                    throw new SocketTimeoutException("operation timed out (" + n + ")");
                }
                throw new ConnectException("Unable to connect!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connect(SocketAddress socketAddress, int n, final ConnectObserver connectObserver) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.shutdown) {
                connectObserver.shutdown();
                return false;
            }
            this.connecter = connectObserver;
        }
        try {
            object = (InetSocketAddress)socketAddress;
            if (((InetSocketAddress)object).isUnresolved()) {
                throw new IOException("unresolved: " + socketAddress);
            }
            if (this.getChannel().connect(socketAddress)) {
                NIODispatcher.instance().getScheduledExecutorService().execute(new Runnable(){

                    public void run() {
                        NIODispatcher.instance().register(AbstractNBSocket.this.getChannel(), AbstractNBSocket.this);
                        try {
                            connectObserver.handleConnect(AbstractNBSocket.this);
                        }
                        catch (IOException iOException) {
                            NIODispatcher.instance().executeLaterAlways(new Runnable(){

                                public void run() {
                                    AbstractNBSocket.this.shutdown();
                                }
                            });
                        }
                    }
                });
                return true;
            }
            NIODispatcher.instance().registerConnect(this.getChannel(), this, n);
            return false;
        }
        catch (IOException iOException) {
            NIODispatcher.instance().executeLaterAlways(new Runnable(){

                public void run() {
                    AbstractNBSocket.this.shutdown();
                }
            });
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final InputStream getInputStream() throws IOException {
        ReadObserver readObserver;
        if (this.isClosed() || this.isShutdown()) {
            throw new IOException("Socket closed.");
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (this.isShutdown()) {
                throw new IOException("Socket closed.");
            }
            readObserver = this.reader;
        }
        if (readObserver instanceof NIOInputStream) {
            object = (NIOInputStream)readObserver;
            InputStream inputStream = ((NIOInputStream)object).getInputStream();
            ((NIOInputStream)object).interestRead(true);
            return inputStream;
        }
        object = new Callable<InputStream>(){

            @Override
            public InputStream call() throws IOException {
                NIOInputStream nIOInputStream = new NIOInputStream(AbstractNBSocket.this, AbstractNBSocket.this, null).init();
                AbstractNBSocket.this.setReadObserver(nIOInputStream);
                return nIOInputStream.getInputStream();
            }
        };
        Future future = NIODispatcher.instance().getScheduledExecutorService().submit(object);
        try {
            return (InputStream)future.get();
        }
        catch (ExecutionException executionException) {
            throw (IOException)new IOException().initCause(executionException.getCause());
        }
        catch (InterruptedException interruptedException) {
            throw (IOException)new IOException().initCause(interruptedException.getCause());
        }
    }

    public final OutputStream getOutputStream() throws IOException {
        if (this.isClosed() || this.isShutdown()) {
            throw new IOException("Socket closed.");
        }
        NIOOutputStream nIOOutputStream = this.nioOutputStream;
        if (nIOOutputStream != null) {
            return nIOOutputStream.getOutputStream();
        }
        throw new IllegalStateException("blocking I/O not in use!");
    }

    public long getReadTimeout() {
        if (this.reader instanceof NIOInputStream) {
            return 0L;
        }
        try {
            return this.getSoTimeout();
        }
        catch (SocketException socketException) {
            return 0L;
        }
    }

    public final void handleIOException(IOException iOException) {
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void shutdown() {
        Future<?> future = this.LOCK;
        synchronized (future) {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Shutting down socket & streams for: " + this));
        }
        if (VersionUtils.isJavaVersionOrAbove("1.5.0_10") || NIODispatcher.instance().isDispatchThread()) {
            this.shutdownSocketAndChannels();
        } else {
            future = NIODispatcher.instance().getScheduledExecutorService().submit(new Runnable(){

                public void run() {
                    AbstractNBSocket.this.shutdownSocketAndChannels();
                }
            });
            while (true) {
                try {
                    future.get();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                catch (ExecutionException executionException) {
                    throw new IllegalStateException(executionException);
                }
                break;
            }
        }
        this.shutdownObservers();
        NIODispatcher.instance().getScheduledExecutorService().execute(new Runnable(){

            public void run() {
                if (AbstractNBSocket.this.nioOutputStream != null) {
                    AbstractNBSocket.this.nioOutputStream.shutdown();
                }
                AbstractNBSocket.this.nioOutputStream = null;
                AbstractNBSocket.this.reader = new NoOpReader();
                AbstractNBSocket.this.writer = new NoOpWriter();
                AbstractNBSocket.this.connecter = null;
                AbstractNBSocket.this.shutdownObserver = null;
            }
        });
    }

    protected void shutdownObservers() {
        this.reader.shutdown();
        this.writer.shutdown();
        if (this.connecter != null) {
            this.connecter.shutdown();
        }
        if (this.shutdownObserver != null) {
            this.shutdownObserver.shutdown();
        }
    }

    private void shutdownSocketAndChannels() {
        this.shutdownImpl();
        try {
            this.getChannel().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isShutdown() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.shutdown;
        }
    }
}

