/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.limewire.io.IOUtils;
import org.limewire.io.IP;
import org.limewire.io.NetworkUtils;
import org.limewire.net.SocketsManager;
import org.limewire.net.WhoIsRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WhoIsRequestImpl
implements WhoIsRequest {
    protected Map<String, String> servers;
    protected String name;
    protected Map<String, String> values;
    protected String whoisServer;
    protected Set<String> referrals;
    protected SocketsManager socketsManager;

    public WhoIsRequestImpl(String string, SocketsManager socketsManager, Map<String, String> map) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("Zero-length name is not allowed.");
        }
        int n = string.lastIndexOf(".");
        if (n == -1 || n == string.length() - 1) {
            throw new IllegalArgumentException("Invalid request name.");
        }
        this.name = string;
        this.values = new HashMap<String, String>();
        this.socketsManager = socketsManager;
        this.referrals = new HashSet<String>();
        this.servers = map;
    }

    @Override
    public void doRequest() throws IOException {
        if (this.whoisServer == null) {
            this.whoisServer = this.getWhoIsServer();
        }
        if (this.whoisServer == null) {
            throw new IllegalArgumentException("Unsupported request name, '" + this.name + "'");
        }
        this.referrals.add(this.whoisServer);
        Object object = new StringTokenizer(this.doRequestGetWhoIsResponse(), "\r\n");
        String string = null;
        StringBuilder stringBuilder = new StringBuilder(100);
        boolean bl = false;
        while (((StringTokenizer)object).hasMoreTokens()) {
            int n = 0;
            String string2 = ((StringTokenizer)object).nextToken().trim();
            if (bl) {
                if (-1 == string2.indexOf("Registrant:")) {
                    continue;
                }
            } else {
                if (-1 != string2.indexOf(">>>") || -1 != string2.indexOf("NOTICE:") || -1 != string2.indexOf("TERMS OF USE:")) {
                    bl = true;
                    continue;
                }
                if (string2.startsWith("#")) continue;
            }
            if (string != null) {
                n = string2.indexOf(":");
                if (-1 != n) {
                    this.setValue(string.toUpperCase(Locale.ENGLISH), stringBuilder.toString());
                    string = string2.substring(0, n);
                    stringBuilder = new StringBuilder(100);
                    if ((string2 = string2.substring(n + 1).trim()).length() <= 0) continue;
                    if (string2.startsWith("//")) {
                        string = null;
                        continue;
                    }
                    this.setValue(string.toUpperCase(Locale.ENGLISH), string2);
                    string = null;
                    continue;
                }
                if (stringBuilder.length() != 0) {
                    stringBuilder.append(" ");
                    stringBuilder.append(string2);
                    continue;
                }
                stringBuilder.append(string2);
                continue;
            }
            n = string2.indexOf(":");
            if (-1 == n) continue;
            string = string2.substring(0, n);
            if ((string2 = string2.substring(n + 1).trim()).length() <= 0) continue;
            if (string2.startsWith("//")) {
                string = null;
                continue;
            }
            this.setValue(string.toUpperCase(Locale.ENGLISH), string2);
            string = null;
        }
        if (this.name != null) {
            this.setValue(this.name.toUpperCase(Locale.ENGLISH), stringBuilder.toString());
        }
        if ((object = this.values.get("WHOIS SERVER")) != null && ((String)object).length() != 0 && !this.referrals.contains(object)) {
            this.whoisServer = object;
            this.doRequest();
        }
    }

    public String getValue(String string) {
        return this.values.get(string);
    }

    protected void setValue(String string, String string2) {
        this.values.put(string, string2);
    }

    @Override
    public IP getNetRange() {
        String string = this.getValue("CIDR");
        if (string != null) {
            return new IP(string);
        }
        return null;
    }

    protected String doRequestGetWhoIsResponse() throws IOException {
        StringBuilder stringBuilder = new StringBuilder(1000);
        Socket socket = null;
        try {
            socket = this.socketsManager.connect(new InetSocketAddress(this.whoisServer, 43), 0);
            InputStream inputStream = socket.getInputStream();
            OutputStream outputStream = socket.getOutputStream();
            byte[] byArray = new byte[1000];
            int n = 0;
            outputStream.write((this.name + "\r\n").getBytes());
            try {
                while (0 < (n = inputStream.read(byArray, 0, 1000))) {
                    if (n <= 0) continue;
                    stringBuilder.append(new String(byArray, 0, n, "US-ASCII"));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        catch (IOException iOException) {
            try {
                throw iOException;
            }
            catch (Throwable throwable) {
                IOUtils.close(socket);
                throw throwable;
            }
        }
        IOUtils.close(socket);
        return stringBuilder.toString();
    }

    public String getWhoIsServer() {
        String string = null;
        string = NetworkUtils.isDottedIPV4(this.name) ? this.servers.get("0") : this.servers.get(this.name.substring(this.name.lastIndexOf(".") + 1).toLowerCase(Locale.ENGLISH));
        return string;
    }
}

