/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.net;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.limewire.io.NetworkUtils;
import org.limewire.io.SimpleNetworkInstanceUtils;
import org.limewire.net.EmptyProxySettings;
import org.limewire.net.EmptySocketBindingSettings;
import org.limewire.net.ProxyManagerImpl;
import org.limewire.net.SimpleSocketController;
import org.limewire.net.SocketController;
import org.limewire.net.SocketsManager;
import org.limewire.nio.NBSocket;
import org.limewire.nio.NBSocketFactory;
import org.limewire.nio.observer.ConnectObserver;

@Singleton
public class SocketsManagerImpl
implements SocketsManager {
    private final SocketController socketController;

    public SocketsManagerImpl() {
        this(new SimpleSocketController(new ProxyManagerImpl(new EmptyProxySettings(), new SimpleNetworkInstanceUtils()), new EmptySocketBindingSettings()));
    }

    @Inject
    public SocketsManagerImpl(SocketController socketController) {
        this.socketController = socketController;
    }

    public Socket create(SocketsManager.ConnectType connectType) throws IOException {
        return connectType.getFactory().createSocket();
    }

    public Socket connect(NBSocket nBSocket, InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, int n, SocketsManager.ConnectType connectType) throws IOException {
        return this.connect(nBSocket, inetSocketAddress, inetSocketAddress2, n, null, connectType);
    }

    public Socket connect(InetSocketAddress inetSocketAddress, int n) throws IOException {
        return this.connect(inetSocketAddress, n, SocketsManager.ConnectType.PLAIN);
    }

    public Socket connect(InetSocketAddress inetSocketAddress, int n, SocketsManager.ConnectType connectType) throws IOException {
        return this.connect(inetSocketAddress, n, null, connectType);
    }

    public Socket connect(InetSocketAddress inetSocketAddress, int n, ConnectObserver connectObserver) throws IOException {
        return this.connect(inetSocketAddress, n, connectObserver, SocketsManager.ConnectType.PLAIN);
    }

    public Socket connect(InetSocketAddress inetSocketAddress, int n, ConnectObserver connectObserver, SocketsManager.ConnectType connectType) throws IOException {
        return this.connect(null, null, inetSocketAddress, n, connectObserver, connectType);
    }

    public Socket connect(final NBSocket nBSocket, InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, int n, ConnectObserver connectObserver, SocketsManager.ConnectType connectType) throws IOException {
        if (!NetworkUtils.isValidPort(inetSocketAddress2.getPort())) {
            throw new IllegalArgumentException("port out of range: " + inetSocketAddress2.getPort());
        }
        if (inetSocketAddress2.isUnresolved()) {
            throw new IOException("address must be resolved!");
        }
        if (nBSocket == null) {
            return this.socketController.connect(connectType.getFactory(), inetSocketAddress2, null, n, connectObserver);
        }
        NBSocketFactory nBSocketFactory = new NBSocketFactory(){

            public NBSocket createSocket() throws IOException {
                return nBSocket;
            }

            public NBSocket createSocket(String string, int n) throws IOException, UnknownHostException {
                throw new UnsupportedOperationException();
            }

            public NBSocket createSocket(InetAddress inetAddress, int n) throws IOException {
                throw new UnsupportedOperationException();
            }

            public NBSocket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException, UnknownHostException {
                throw new UnsupportedOperationException();
            }

            public NBSocket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
                throw new UnsupportedOperationException();
            }
        };
        return this.socketController.connect(nBSocketFactory, inetSocketAddress2, inetSocketAddress, n, connectObserver);
    }

    public boolean removeConnectObserver(ConnectObserver connectObserver) {
        return this.socketController.removeConnectObserver(connectObserver);
    }

    public int getNumAllowedSockets() {
        return this.socketController.getNumAllowedSockets();
    }

    public int getNumWaitingSockets() {
        return this.socketController.getNumWaitingSockets();
    }
}

