/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.net;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.IOUtils;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.net.ProxyManager;
import org.limewire.net.ProxySettings;
import org.limewire.nio.channel.NIOMultiplexor;
import org.limewire.nio.observer.ConnectObserver;
import org.limewire.nio.statemachine.BlockingStateMachine;
import org.limewire.nio.statemachine.IOState;
import org.limewire.nio.statemachine.IOStateMachine;
import org.limewire.nio.statemachine.IOStateObserver;
import org.limewire.nio.statemachine.PossibleIOState;
import org.limewire.nio.statemachine.ReadSkipState;
import org.limewire.nio.statemachine.ReadState;
import org.limewire.nio.statemachine.SimpleReadState;
import org.limewire.nio.statemachine.SimpleWriteState;
import org.limewire.util.BufferUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
class ProxyManagerImpl
implements ProxyManager {
    private static final Log LOG = LogFactory.getLog(ProxyManagerImpl.class);
    private final ProxySettings proxySettings;
    private final NetworkInstanceUtils networkInstanceUtils;

    @Inject
    public ProxyManagerImpl(ProxySettings proxySettings, NetworkInstanceUtils networkInstanceUtils) {
        this.proxySettings = proxySettings;
        this.networkInstanceUtils = networkInstanceUtils;
    }

    @Override
    public ProxySettings.ProxyType getProxyType(InetAddress inetAddress) {
        boolean bl;
        ProxySettings.ProxyType proxyType = this.proxySettings.getCurrentProxyType();
        assert (proxyType != null);
        boolean bl2 = bl = proxyType != ProxySettings.ProxyType.NONE && (!this.networkInstanceUtils.isPrivateAddress(inetAddress) || this.proxySettings.isProxyForPrivateEnabled());
        if (bl) {
            return proxyType;
        }
        return ProxySettings.ProxyType.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Socket establishProxy(ProxySettings.ProxyType proxyType, Socket socket, InetSocketAddress inetSocketAddress, int n) throws IOException {
        socket.setSoTimeout(n);
        List<IOState> list = this.getProxyStates(proxyType, inetSocketAddress);
        InputStream inputStream = socket.getInputStream();
        OutputStream outputStream = socket.getOutputStream();
        BlockingStateMachine blockingStateMachine = new BlockingStateMachine(list, inputStream, outputStream);
        try {
            blockingStateMachine.process();
        }
        finally {
            blockingStateMachine.shutdown();
        }
        socket.setSoTimeout(0);
        return socket;
    }

    @Override
    public ProxyManager.ProxyConnector getConnectorFor(ProxySettings.ProxyType proxyType, ConnectObserver connectObserver, InetSocketAddress inetSocketAddress, int n) {
        return new ProxyConnectorImpl(proxyType, connectObserver, inetSocketAddress, n);
    }

    @Override
    public InetSocketAddress getProxyHost() throws UnknownHostException {
        return new InetSocketAddress(this.proxySettings.getProxyHost(), this.proxySettings.getProxyPort());
    }

    private List<IOState> getProxyStates(ProxySettings.ProxyType proxyType, InetSocketAddress inetSocketAddress) throws IOException {
        switch (proxyType) {
            case HTTP: {
                return this.getHttpStates(inetSocketAddress);
            }
            case SOCKS4: {
                return this.getSocksV4States(inetSocketAddress);
            }
            case SOCKS5: {
                return this.getSocksV5States(inetSocketAddress);
            }
        }
        throw new IOException("Unknown proxy type.");
    }

    private List<IOState> getSocksV4States(InetSocketAddress inetSocketAddress) {
        LinkedList<IOState> linkedList = new LinkedList<IOState>();
        byte[] byArray = inetSocketAddress.getAddress().getAddress();
        int n = inetSocketAddress.getPort();
        byte[] byArray2 = new byte[]{(byte)(n >> 8), (byte)n};
        boolean bl = this.proxySettings.isProxyAuthenticationRequired();
        String string = this.proxySettings.getProxyUsername();
        byte[] byArray3 = bl ? string.getBytes() : new byte[]{};
        ByteBuffer byteBuffer = ByteBuffer.allocate(2 + byArray2.length + byArray.length + byArray3.length + 1);
        byteBuffer.put((byte)4);
        byteBuffer.put((byte)1);
        byteBuffer.put(byArray2);
        byteBuffer.put(byArray);
        byteBuffer.put(byArray3);
        byteBuffer.put((byte)0);
        byteBuffer.flip();
        linkedList.add(new SimpleWriteState(byteBuffer));
        linkedList.add(new SimpleReadState(8){

            public void validateBuffer(ByteBuffer byteBuffer) throws IOException {
                byte by = byteBuffer.get(0);
                if (by != 0 && by != 4) {
                    throw new IOException("Invalid version from socks proxy: " + by + " expected 0 or 4");
                }
                byte by2 = byteBuffer.get(1);
                if (by2 != 90) {
                    throw new IOException("Request rejected with status: " + by2);
                }
            }
        });
        return linkedList;
    }

    private List<IOState> getSocksV5States(InetSocketAddress inetSocketAddress) {
        String string;
        byte[] byArray;
        LinkedList<IOState> linkedList = new LinkedList<IOState>();
        if (this.proxySettings.isProxyAuthenticationRequired()) {
            byte[] byArray2 = new byte[3];
            byArray2[0] = 2;
            byArray2[1] = 0;
            byArray = byArray2;
            byArray2[2] = 2;
        } else {
            byte[] byArray3 = new byte[2];
            byArray3[0] = 1;
            byArray = byArray3;
            byArray3[1] = 0;
        }
        byte[] byArray4 = byArray;
        ByteBuffer byteBuffer = ByteBuffer.allocate(1 + byArray4.length);
        byteBuffer.put((byte)5);
        byteBuffer.put(byArray4);
        byteBuffer.flip();
        linkedList.add(new SimpleWriteState(byteBuffer));
        final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        linkedList.add(new SimpleReadState(2){

            public void validateBuffer(ByteBuffer byteBuffer) throws IOException {
                byte by = byteBuffer.get(0);
                if (by != 5) {
                    throw new IOException("Invalid version from socks proxy: " + by + " expected 5");
                }
                byte by2 = byteBuffer.get(1);
                if (by2 == 2) {
                    atomicBoolean.set(true);
                }
            }
        });
        String string2 = this.proxySettings.getProxyUsername();
        if (string2 == null) {
            string2 = "";
        }
        if ((string = this.proxySettings.getProxyPassword()) == null) {
            string = "";
        }
        byteBuffer = ByteBuffer.allocate(2 + string2.length() + 1 + string.length());
        byteBuffer.put((byte)1);
        byteBuffer.put((byte)string2.length());
        byteBuffer.put(string2.getBytes());
        byteBuffer.put((byte)string.length());
        byteBuffer.put(string.getBytes());
        byteBuffer.flip();
        linkedList.add(new PossibleIOState(atomicBoolean, new SimpleWriteState(byteBuffer)));
        linkedList.add(new PossibleIOState(atomicBoolean, new SimpleReadState(2){

            public void validateBuffer(ByteBuffer byteBuffer) throws IOException {
                byte by = byteBuffer.get(0);
                if (by != 1) {
                    throw new IOException("Invalid version for authentication: " + by + " expected 1");
                }
                byte by2 = byteBuffer.get(1);
                if (by2 != 0) {
                    throw new IOException("Authentication failed with status: " + by2);
                }
            }
        }));
        byte[] byArray5 = inetSocketAddress.getAddress().getAddress();
        int n = inetSocketAddress.getPort();
        byte[] byArray6 = new byte[]{(byte)(n >> 8), (byte)n};
        byteBuffer = ByteBuffer.allocate(4 + byArray5.length + byArray6.length);
        byteBuffer.put((byte)5);
        byteBuffer.put((byte)1);
        byteBuffer.put((byte)0);
        byteBuffer.put((byte)1);
        byteBuffer.put(byArray5);
        byteBuffer.put(byArray6);
        byteBuffer.flip();
        linkedList.add(new SimpleWriteState(byteBuffer));
        final AtomicLong atomicLong = new AtomicLong(0L);
        final AtomicBoolean atomicBoolean2 = new AtomicBoolean(false);
        linkedList.add(new SimpleReadState(4){

            public void validateBuffer(ByteBuffer byteBuffer) throws IOException {
                byte by = byteBuffer.get(0);
                if (by != 5) {
                    throw new IOException("Invalid version from socks proxy: " + by + " expected 5");
                }
                byte by2 = byteBuffer.get(1);
                if (by2 != 0) {
                    throw new IOException("Request rejected with status: " + by2);
                }
                byte by3 = byteBuffer.get(3);
                switch (by3) {
                    case 1: {
                        atomicLong.set(6L);
                        break;
                    }
                    case 3: {
                        atomicBoolean2.set(true);
                        break;
                    }
                    case 4: {
                        atomicLong.set(18L);
                    }
                }
            }
        });
        linkedList.add(new PossibleIOState(atomicBoolean2, new SimpleReadState(1){

            public void validateBuffer(ByteBuffer byteBuffer) throws IOException {
                atomicLong.set(byteBuffer.get(0) + 2);
            }
        }));
        linkedList.add(new ReadSkipState(atomicLong));
        return linkedList;
    }

    private List<IOState> getHttpStates(InetSocketAddress inetSocketAddress) {
        LinkedList<IOState> linkedList = new LinkedList<IOState>();
        String string = "CONNECT " + inetSocketAddress.getAddress().getHostAddress() + ":" + inetSocketAddress.getPort() + " HTTP/1.0\r\n\r\n";
        ByteBuffer byteBuffer = ByteBuffer.wrap(string.getBytes());
        linkedList.add(new SimpleWriteState(byteBuffer));
        linkedList.add(new ReadState(){
            private StringBuilder sb = new StringBuilder();
            private boolean found200 = false;
            private ByteBuffer buffer;

            protected boolean processRead(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer) throws IOException {
                int n;
                if (this.buffer == null) {
                    this.buffer = byteBuffer.slice();
                    this.buffer.limit(1);
                }
                while ((n = readableByteChannel.read(this.buffer)) > 0) {
                    this.buffer.flip();
                    if (BufferUtils.readLine(this.buffer, this.sb)) {
                        if (!this.found200) {
                            if (this.sb.indexOf("200") == -1) {
                                throw new IOException("HTTP connection failed");
                            }
                            this.found200 = true;
                        }
                        if (this.sb.length() == 0) {
                            return false;
                        }
                        this.sb = new StringBuilder();
                    }
                    if (this.sb.length() > 2048) {
                        throw new IOException("header too big.");
                    }
                    this.buffer.position(0);
                    this.buffer.limit(1);
                }
                if (n == -1) {
                    throw new IOException("EOF");
                }
                return true;
            }

            public long getAmountProcessed() {
                return -1L;
            }
        });
        return linkedList;
    }

    private class ProxyConnectorImpl
    implements ProxyManager.ProxyConnector,
    IOStateObserver {
        private final ProxySettings.ProxyType proxyType;
        private final ConnectObserver delegate;
        private final InetSocketAddress addr;
        private final int timeout;
        private volatile Socket socket;

        ProxyConnectorImpl(ProxySettings.ProxyType proxyType, ConnectObserver connectObserver, InetSocketAddress inetSocketAddress, int n) {
            this.proxyType = proxyType;
            this.delegate = connectObserver;
            this.addr = inetSocketAddress;
            this.timeout = n;
        }

        public void handleConnect(Socket socket) throws IOException {
            this.socket = socket;
            socket.setSoTimeout(this.timeout);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Connected to proxy, beginning proxy handshake for addr: " + this.addr));
            }
            IOStateMachine iOStateMachine = new IOStateMachine(this, ProxyManagerImpl.this.getProxyStates(this.proxyType, this.addr));
            ((NIOMultiplexor)((Object)this.socket)).setReadObserver(iOStateMachine);
            ((NIOMultiplexor)((Object)this.socket)).setWriteObserver(iOStateMachine);
        }

        public void shutdown() {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Failed to connect with proxy to addr: " + this.addr));
            }
            this.delegate.shutdown();
        }

        public void handleIOException(IOException iOException) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Failed to connect with proxy to addr: " + this.addr), (Throwable)iOException);
            }
            this.delegate.shutdown();
        }

        public ConnectObserver getDelegateObserver() {
            return this.delegate;
        }

        public void handleStatesFinished() {
            try {
                this.socket.setSoTimeout(0);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Finished proxy handshake, notifying connector for address: " + this.addr));
            }
            try {
                this.delegate.handleConnect(this.socket);
            }
            catch (IOException iOException) {
                IOUtils.close(this.socket);
            }
        }
    }
}

