/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.net;

import com.google.inject.Inject;
import java.net.Socket;
import java.net.SocketException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.concurrent.ThreadExecutor;
import org.limewire.io.IOUtils;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.io.NetworkUtils;
import org.limewire.net.ConnectionAcceptor;
import org.limewire.net.ConnectionDispatcher;

public class ConnectionDispatcherImpl
implements ConnectionDispatcher {
    private static final Log LOG = LogFactory.getLog(ConnectionDispatcherImpl.class);
    private final Map<String, Delegator> protocols = Collections.synchronizedMap(new HashMap());
    private int longestWordSize = 0;
    private final NetworkInstanceUtils networkInstanceUtils;

    @Inject
    public ConnectionDispatcherImpl(NetworkInstanceUtils networkInstanceUtils) {
        this.networkInstanceUtils = networkInstanceUtils;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaximumWordSize() {
        Map<String, Delegator> map = this.protocols;
        synchronized (map) {
            return this.longestWordSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionAcceptor(ConnectionAcceptor connectionAcceptor, boolean bl, String ... stringArray) {
        Delegator delegator = new Delegator(connectionAcceptor, bl, connectionAcceptor.isBlocking());
        Map<String, Delegator> map = this.protocols;
        synchronized (map) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].length() > this.longestWordSize) {
                    this.longestWordSize = stringArray[i].length();
                }
                this.protocols.put(stringArray[i], delegator);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionAcceptor(String ... stringArray) {
        Map<String, Delegator> map = this.protocols;
        synchronized (map) {
            this.protocols.keySet().removeAll(Arrays.asList(stringArray));
            this.longestWordSize = 0;
            for (String string : this.protocols.keySet()) {
                if (string.length() <= this.longestWordSize) continue;
                this.longestWordSize = string.length();
            }
        }
    }

    public boolean isValidProtocolWord(String string) {
        return this.protocols.containsKey(string);
    }

    public void dispatch(String string, Socket socket, boolean bl) {
        try {
            socket.setSoTimeout(0);
        }
        catch (SocketException socketException) {
            socketException.printStackTrace();
            LOG.warn((Object)"Unable to set soTimeout, closing client", (Throwable)socketException);
            IOUtils.close(socket);
            return;
        }
        Delegator delegator = this.protocols.get(string);
        if (delegator == null) {
            System.out.println("no pro: " + string);
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("Unknown protocol: " + string));
            }
            IOUtils.close(socket);
            return;
        }
        delegator.delegate(string, socket, bl);
    }

    private class Delegator {
        private final ConnectionAcceptor acceptor;
        private final boolean localOnly;
        private final boolean blocking;

        Delegator(ConnectionAcceptor connectionAcceptor, boolean bl, boolean bl2) {
            this.acceptor = connectionAcceptor;
            this.localOnly = bl;
            this.blocking = bl2;
        }

        public void delegate(final String string, final Socket socket, boolean bl) {
            boolean bl2 = NetworkUtils.isLocalHost(socket);
            boolean bl3 = false;
            if (this.localOnly && !bl2) {
                LOG.debug((Object)"Dropping because we want a local connection, and this isn't localhost");
                bl3 = true;
            }
            if (!this.localOnly && bl2 && ConnectionDispatcherImpl.this.networkInstanceUtils.isPrivateAddress(socket.getLocalAddress())) {
                LOG.debug((Object)"Dropping because we want an external connection, and this is localhost");
                bl3 = true;
            }
            if (bl3) {
                IOUtils.close(socket);
                return;
            }
            if (this.blocking && bl) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        Delegator.this.acceptor.acceptConnection(string, socket);
                    }
                };
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Spawning new thread to dispatch: " + string));
                }
                ThreadExecutor.startThread(runnable, "IncomingConnection");
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Handling dispatched word: " + string + " in same thread"));
                }
                this.acceptor.acceptConnection(string, socket);
            }
        }
    }
}

