/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.net;

import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.net.ConnectionDispatcher;
import org.limewire.nio.channel.AbstractChannelInterestReader;
import org.limewire.nio.ssl.SSLUtils;
import org.limewire.nio.ssl.TLSNIOSocket;
import org.limewire.util.BufferUtils;

public class AsyncConnectionDispatcher
extends AbstractChannelInterestReader {
    private static final Log LOG = LogFactory.getLog(AsyncConnectionDispatcher.class);
    private final ConnectionDispatcher dispatcher;
    private final Socket socket;
    private final String allowedWord;
    private boolean finished = false;

    public AsyncConnectionDispatcher(ConnectionDispatcher connectionDispatcher, Socket socket, String string) {
        super(connectionDispatcher.getMaximumWordSize() + 1);
        if (socket == null) {
            throw new IllegalArgumentException();
        }
        this.dispatcher = connectionDispatcher;
        this.socket = socket;
        this.allowedWord = string;
    }

    public void handleRead() throws IOException {
        if (this.finished) {
            this.source.interestRead(false);
            return;
        }
        int n = 0;
        while (this.buffer.hasRemaining() && (n = this.source.read(this.buffer)) > 0) {
        }
        for (int i = 0; i < this.buffer.position(); ++i) {
            if (this.buffer.get(i) != 32) continue;
            String string = new String(this.buffer.array(), 0, i);
            if (this.dispatcher.isValidProtocolWord(string)) {
                if (this.allowedWord != null && !this.allowedWord.equals(string)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Legal but wrong word: " + string));
                    }
                    throw new IOException("wrong word!");
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Dispatching word: " + string));
                }
                this.buffer.limit(this.buffer.position()).position(i + 1);
                this.source.interestRead(false);
                this.dispatcher.dispatch(string, this.socket, true);
            } else {
                this.startTLS();
            }
            this.finished = true;
            return;
        }
        if (!this.buffer.hasRemaining()) {
            this.startTLS();
            this.finished = true;
            return;
        }
        if (n == -1) {
            this.close();
            return;
        }
    }

    private void startTLS() throws IOException {
        if (!SSLUtils.isTLSEnabled(this.socket) && SSLUtils.isStartTLSCapable(this.socket)) {
            LOG.debug((Object)"Attempting to start TLS");
            this.buffer.flip();
            TLSNIOSocket tLSNIOSocket = SSLUtils.startTLS(this.socket, this.buffer);
            tLSNIOSocket.setReadObserver(new AsyncConnectionDispatcher(this.dispatcher, tLSNIOSocket, this.allowedWord));
        } else {
            this.close();
        }
    }

    public int read(ByteBuffer byteBuffer) {
        return BufferUtils.transfer(this.buffer, byteBuffer, false);
    }

    public long read(ByteBuffer[] byteBufferArray) {
        return BufferUtils.transfer(this.buffer, byteBufferArray, 0, byteBufferArray.length, false);
    }

    public long read(ByteBuffer[] byteBufferArray, int n, int n2) {
        return BufferUtils.transfer(this.buffer, byteBufferArray, n, n2, false);
    }
}

