/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.util;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.limewire.mojito.KUID;
import org.limewire.mojito.MojitoDHT;
import org.limewire.mojito.MojitoFactory;
import org.limewire.mojito.concurrent.DHTFuture;
import org.limewire.mojito.result.BootstrapResult;
import org.limewire.mojito.result.PingResult;
import org.limewire.mojito.settings.KademliaSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MojitoUtils {
    private MojitoUtils() {
    }

    public static DHTFuture<BootstrapResult> bootstrap(MojitoDHT mojitoDHT, SocketAddress socketAddress) throws ExecutionException, InterruptedException {
        PingResult pingResult = (PingResult)mojitoDHT.ping(socketAddress).get();
        return mojitoDHT.bootstrap(pingResult.getContact());
    }

    public static List<MojitoDHT> createBootStrappedDHTs(int n) throws Exception {
        return MojitoUtils.createBootStrappedDHTs(n, 3000);
    }

    public static List<MojitoDHT> createBootStrappedDHTs(int n, int n2) throws Exception {
        if (n < 1) {
            throw new IllegalArgumentException("only values >= 1");
        }
        int n3 = KademliaSettings.REPLICATION_PARAMETER.getValue();
        ArrayList<MojitoDHT> arrayList = new ArrayList<MojitoDHT>();
        for (int i = 0; i < n * n3; ++i) {
            MojitoDHT mojitoDHT = MojitoFactory.createDHT("DHT-" + i);
            mojitoDHT.bind(new InetSocketAddress(n2 + i));
            mojitoDHT.start();
            if (i > 0) {
                mojitoDHT.bootstrap(new InetSocketAddress("localhost", n2)).get();
            }
            arrayList.add(mojitoDHT);
        }
        ((MojitoDHT)arrayList.get(0)).bootstrap(((MojitoDHT)arrayList.get(1)).getContactAddress()).get();
        return arrayList;
    }

    public static Map<KUID, MojitoDHT> createBootStrappedDHTsMap(int n) throws Exception {
        return MojitoUtils.createBootStrappedDHTsMap(n, 3000);
    }

    public static Map<KUID, MojitoDHT> createBootStrappedDHTsMap(int n, int n2) throws Exception {
        if (n < 1) {
            throw new IllegalArgumentException("only values >= 1");
        }
        int n3 = KademliaSettings.REPLICATION_PARAMETER.getValue();
        LinkedHashMap<KUID, MojitoDHT> linkedHashMap = new LinkedHashMap<KUID, MojitoDHT>();
        MojitoDHT mojitoDHT = null;
        for (int i = 0; i < n * n3; ++i) {
            MojitoDHT mojitoDHT2 = MojitoFactory.createDHT("DHT-" + i);
            mojitoDHT2.bind(new InetSocketAddress(n2 + i));
            mojitoDHT2.start();
            if (i > 0) {
                mojitoDHT2.bootstrap(new InetSocketAddress("localhost", n2)).get();
            } else {
                mojitoDHT = mojitoDHT2;
            }
            linkedHashMap.put(mojitoDHT2.getLocalNodeID(), mojitoDHT2);
        }
        if (mojitoDHT != null) {
            mojitoDHT.bootstrap(new InetSocketAddress("localhost", 3001)).get();
        }
        return linkedHashMap;
    }
}

