/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.util;

import java.util.ArrayList;
import java.util.Collection;
import org.limewire.mojito.KUID;
import org.limewire.mojito.db.DHTValueEntity;
import org.limewire.mojito.db.DHTValueType;
import org.limewire.mojito.db.Storable;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.RouteTable;
import org.limewire.mojito.settings.DatabaseSettings;
import org.limewire.mojito.settings.KademliaSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseUtils {
    private DatabaseUtils() {
    }

    public static long getExpirationTime(RouteTable routeTable, DHTValueEntity dHTValueEntity) {
        KUID kUID = dHTValueEntity.getPrimaryKey();
        int n = KademliaSettings.REPLICATION_PARAMETER.getValue();
        Collection<Contact> collection = routeTable.select(kUID, n, RouteTable.SelectMode.ALL);
        long l = dHTValueEntity.getCreationTime();
        long l2 = DatabaseSettings.VALUE_EXPIRATION_TIME.getValue();
        if (collection.size() < n || collection.contains(routeTable.getLocalNode())) {
            return l + l2;
        }
        KUID kUID2 = routeTable.getBucket(kUID).getBucketID();
        KUID kUID3 = routeTable.getBucket(routeTable.getLocalNode().getNodeID()).getBucketID();
        KUID kUID4 = kUID3.xor(kUID2);
        int n2 = kUID4.toBigInteger().getLowestSetBit();
        float f = 0.0f;
        if (n2 >= 0) {
            f = (float)(160 - n2) / 160.0f;
        }
        return l + (long)((float)l2 - (float)l2 * f);
    }

    public static boolean isExpired(RouteTable routeTable, DHTValueEntity dHTValueEntity) {
        return System.currentTimeMillis() >= DatabaseUtils.getExpirationTime(routeTable, dHTValueEntity);
    }

    public static boolean isPublishingRequired(Storable storable) {
        return DatabaseUtils.isPublishingRequired(storable.getPublishTime(), storable.getLocationCount());
    }

    public static boolean isPublishingRequired(long l, int n) {
        if (l <= 0L || n <= 0) {
            return true;
        }
        long l2 = (long)n * DatabaseSettings.VALUE_REPUBLISH_INTERVAL.getValue() / (long)KademliaSettings.REPLICATION_PARAMETER.getValue();
        long l3 = Math.max(l2, DatabaseSettings.MIN_VALUE_REPUBLISH_INTERVAL.getValue());
        long l4 = l + l3;
        return System.currentTimeMillis() >= l4;
    }

    public static boolean isDHTValueType(DHTValueType dHTValueType, DHTValueEntity dHTValueEntity) {
        return dHTValueType.equals(DHTValueType.ANY) || dHTValueType.equals(dHTValueEntity.getValue().getValueType());
    }

    public static Collection<? extends DHTValueEntity> filter(DHTValueType dHTValueType, Collection<? extends DHTValueEntity> collection) {
        if (dHTValueType.equals(DHTValueType.ANY)) {
            return collection;
        }
        ArrayList<DHTValueEntity> arrayList = new ArrayList<DHTValueEntity>(collection.size());
        for (DHTValueEntity dHTValueEntity : collection) {
            if (!DatabaseUtils.isDHTValueType(dHTValueType, dHTValueEntity)) continue;
            arrayList.add(dHTValueEntity);
        }
        return arrayList;
    }

    public static DHTValueEntity getFirstEntityFor(DHTValueType dHTValueType, Collection<? extends DHTValueEntity> collection) {
        for (DHTValueEntity dHTValueEntity : collection) {
            if (!DatabaseUtils.isDHTValueType(dHTValueType, dHTValueEntity)) continue;
            return dHTValueEntity;
        }
        return null;
    }
}

