/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.util;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.mojito.Context;
import org.limewire.mojito.KUID;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.impl.LocalContact;
import org.limewire.mojito.settings.NetworkSettings;
import org.limewire.mojito.util.ContactUtils;
import org.limewire.mojito.util.SameClassFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContactsScrubber {
    private static final Log LOG = LogFactory.getLog(ContactsScrubber.class);
    private final Collection<? extends Contact> nodes;
    private final Map<KUID, Contact> scrubbed;
    private final Collection<Contact> collisions;
    private final boolean isValidResponse;

    public static ContactsScrubber scrub(Context context, Contact contact, Collection<? extends Contact> collection, float f) {
        if (collection.isEmpty()) {
            throw new IllegalArgumentException();
        }
        return new ContactsScrubber(context, contact, collection, f);
    }

    private ContactsScrubber(Context context, Contact contact, Collection<? extends Contact> collection, float f) {
        assert (!collection.isEmpty());
        assert (f >= 0.0f && f <= 1.0f);
        this.nodes = collection;
        this.scrubbed = new LinkedHashMap<KUID, Contact>(collection.size());
        this.collisions = new LinkedHashSet<Contact>(1);
        LocalContact localContact = context.getLocalNode();
        SameClassFilter sameClassFilter = new SameClassFilter(contact);
        boolean bl = false;
        for (Contact contact2 : collection) {
            if (!ContactUtils.isValidSocketAddress(contact2)) {
                if (!LOG.isInfoEnabled()) continue;
                LOG.info((Object)(contact + " sent us a Contact with an invalid IP:Port " + contact2));
                continue;
            }
            if (ContactUtils.isPrivateAddress(contact2)) {
                if (!LOG.isInfoEnabled()) continue;
                if (ContactUtils.isSameNodeID(contact, contact2)) {
                    LOG.info((Object)(contact + " does not know its external address"));
                    continue;
                }
                LOG.info((Object)(contact + " sent a Contact with a private IP:Port: " + contact2));
                continue;
            }
            if (!ContactUtils.isSameAddressSpace(localContact, contact2)) {
                if (!LOG.isInfoEnabled()) continue;
                LOG.info((Object)(contact2 + " is from a different IP address space than local Node"));
                continue;
            }
            if (NetworkSettings.DROP_PUBLIC_IPV4_COMPATIBLE_ADDRESSES.getValue() && ContactUtils.isIPv4CompatibleAddress(contact2)) {
                if (!LOG.isInfoEnabled()) continue;
                LOG.info((Object)(contact2 + " has an IPv4-compatible address"));
                continue;
            }
            if (NetworkSettings.DROP_PRIVATE_IPV4_COMPATIBLE_ADDRESSES.getValue() && ContactUtils.isPrivateIPv4CompatibleAddress(contact2)) {
                if (!LOG.isInfoEnabled()) continue;
                LOG.info((Object)(contact2 + " has a private IPv4-compatible address"));
                continue;
            }
            if (NetworkSettings.FILTER_CLASS_C.getValue() && ContactUtils.isIPv4Address(contact2) && !ContactUtils.isSameNodeID(contact, contact2) && sameClassFilter.isSameNetwork(contact2)) {
                if (!LOG.isInfoEnabled()) continue;
                LOG.info((Object)(contact + " sent one or more Contacts from the same Network-Class: " + contact2));
                continue;
            }
            if (ContactUtils.isCollision(context, contact2)) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)(contact2 + " seems to collide with " + context.getLocalNode()));
                }
                this.collisions.add(contact2);
                continue;
            }
            if (ContactUtils.isLocalContact(context, contact2)) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)"Skipping local Node");
                }
                bl = true;
                continue;
            }
            this.scrubbed.put(contact2.getNodeID(), contact2);
        }
        if (f > 0.0f) {
            float f2;
            int n = this.scrubbed.size() + this.collisions.size();
            if (bl) {
                ++n;
            }
            this.isValidResponse = (f2 = (float)n / (float)collection.size()) >= f;
        } else {
            this.isValidResponse = true;
        }
    }

    public Collection<? extends Contact> getContacts() {
        return this.nodes;
    }

    public Collection<Contact> getScrubbed() {
        return this.scrubbed.values();
    }

    public Collection<Contact> getCollisions() {
        return this.collisions;
    }

    public boolean isValidResponse() {
        return this.isValidResponse;
    }
}

