/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.messages.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketAddress;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.limewire.mojito.Context;
import org.limewire.mojito.io.MessageInputStream;
import org.limewire.mojito.io.MessageOutputStream;
import org.limewire.mojito.messages.DHTMessage;
import org.limewire.mojito.messages.MessageID;
import org.limewire.mojito.messages.StatsResponse;
import org.limewire.mojito.messages.impl.AbstractResponseMessage;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.Version;

public class StatsResponseImpl
extends AbstractResponseMessage
implements StatsResponse {
    private final byte[] statistics;

    public StatsResponseImpl(Context context, Contact contact, MessageID messageID, byte[] byArray) {
        super(context, DHTMessage.OpCode.STATS_RESPONSE, contact, messageID, Version.ZERO);
        this.statistics = byArray;
    }

    public StatsResponseImpl(Context context, SocketAddress socketAddress, MessageID messageID, Version version, MessageInputStream messageInputStream) throws IOException {
        super(context, DHTMessage.OpCode.STATS_RESPONSE, socketAddress, messageID, version, messageInputStream);
        byte[] byArray = messageInputStream.readStatistics();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length * 2);
        byte[] byArray2 = new byte[2048];
        int n = -1;
        while ((n = gZIPInputStream.read(byArray2)) != -1) {
            byteArrayOutputStream.write(byArray2, 0, n);
        }
        gZIPInputStream.close();
        byteArrayOutputStream.close();
        this.statistics = byteArrayOutputStream.toByteArray();
    }

    public byte[] getStatistics() {
        return this.statistics;
    }

    protected void writeBody(MessageOutputStream messageOutputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        gZIPOutputStream.write(this.statistics);
        gZIPOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        messageOutputStream.writeStatistics(byArray);
    }

    public String toString() {
        try {
            return "StatsResponse: " + new String(this.statistics, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }
}

