/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.messages.impl;

import java.io.IOException;
import java.math.BigInteger;
import java.net.SocketAddress;
import org.limewire.mojito.Context;
import org.limewire.mojito.io.MessageInputStream;
import org.limewire.mojito.io.MessageOutputStream;
import org.limewire.mojito.messages.DHTMessage;
import org.limewire.mojito.messages.MessageID;
import org.limewire.mojito.messages.PingResponse;
import org.limewire.mojito.messages.impl.AbstractResponseMessage;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.Version;

public class PingResponseImpl
extends AbstractResponseMessage
implements PingResponse {
    private final SocketAddress externalAddress;
    private final BigInteger estimatedSize;

    public PingResponseImpl(Context context, Contact contact, MessageID messageID, SocketAddress socketAddress, BigInteger bigInteger) {
        super(context, DHTMessage.OpCode.PING_RESPONSE, contact, messageID, Version.ZERO);
        this.externalAddress = socketAddress;
        this.estimatedSize = bigInteger;
    }

    public PingResponseImpl(Context context, SocketAddress socketAddress, MessageID messageID, Version version, MessageInputStream messageInputStream) throws IOException {
        super(context, DHTMessage.OpCode.PING_RESPONSE, socketAddress, messageID, version, messageInputStream);
        this.externalAddress = messageInputStream.readSocketAddress();
        this.estimatedSize = messageInputStream.readDHTSize();
    }

    public SocketAddress getExternalAddress() {
        return this.externalAddress;
    }

    public BigInteger getEstimatedSize() {
        return this.estimatedSize;
    }

    protected void writeBody(MessageOutputStream messageOutputStream) throws IOException {
        messageOutputStream.writeSocketAddress(this.externalAddress);
        messageOutputStream.writeDHTSize(this.estimatedSize);
    }

    public String toString() {
        return "PingResponse: externalAddress=" + this.externalAddress + ", estimatedSize=" + this.estimatedSize;
    }
}

