/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.messages.impl;

import java.io.IOException;
import java.net.SocketAddress;
import org.limewire.mojito.Context;
import org.limewire.mojito.KUID;
import org.limewire.mojito.io.MessageInputStream;
import org.limewire.mojito.io.MessageOutputStream;
import org.limewire.mojito.messages.DHTMessage;
import org.limewire.mojito.messages.LookupRequest;
import org.limewire.mojito.messages.MessageID;
import org.limewire.mojito.messages.impl.AbstractRequestMessage;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.Version;

abstract class AbstractLookupRequest
extends AbstractRequestMessage
implements LookupRequest {
    protected final KUID lookupId;

    public AbstractLookupRequest(Context context, DHTMessage.OpCode opCode, Contact contact, MessageID messageID, Version version, KUID kUID) {
        super(context, opCode, contact, messageID, version);
        this.lookupId = kUID;
    }

    public AbstractLookupRequest(Context context, DHTMessage.OpCode opCode, SocketAddress socketAddress, MessageID messageID, Version version, MessageInputStream messageInputStream) throws IOException {
        super(context, opCode, socketAddress, messageID, version, messageInputStream);
        switch (opCode) {
            case FIND_NODE_REQUEST: 
            case FIND_VALUE_REQUEST: {
                this.lookupId = messageInputStream.readKUID();
                break;
            }
            default: {
                throw new IOException("Unknown opcode for lookup request: " + (Object)((Object)opCode));
            }
        }
    }

    public KUID getLookupID() {
        return this.lookupId;
    }

    protected void writeBody(MessageOutputStream messageOutputStream) throws IOException {
        messageOutputStream.writeKUID(this.lookupId);
    }
}

