/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.messages.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteOrder;
import java.security.Signature;
import java.security.SignatureException;
import org.limewire.io.ByteBufferOutputStream;
import org.limewire.io.NetworkUtils;
import org.limewire.mojito.Context;
import org.limewire.mojito.KUID;
import org.limewire.mojito.io.MessageInputStream;
import org.limewire.mojito.io.MessageOutputStream;
import org.limewire.mojito.messages.DHTMessage;
import org.limewire.mojito.messages.MessageID;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.Vendor;
import org.limewire.mojito.routing.Version;

abstract class AbstractDHTMessage
implements DHTMessage {
    protected final Context context;
    private final DHTMessage.OpCode opcode;
    private final Contact contact;
    private final MessageID messageId;
    private final Version msgVersion;
    private byte[] payload;

    public AbstractDHTMessage(Context context, DHTMessage.OpCode opCode, Contact contact, MessageID messageID, Version version) {
        if (opCode == null) {
            throw new NullPointerException("OpCode is null");
        }
        if (contact == null) {
            throw new NullPointerException("Contact is null");
        }
        if (messageID == null) {
            throw new NullPointerException("MessageID is null");
        }
        if (version == null) {
            throw new NullPointerException("Version is null");
        }
        this.context = context;
        this.opcode = opCode;
        this.contact = contact;
        this.messageId = messageID;
        this.msgVersion = version;
    }

    public AbstractDHTMessage(Context context, DHTMessage.OpCode opCode, SocketAddress socketAddress, MessageID messageID, Version version, MessageInputStream messageInputStream) throws IOException {
        if (opCode == null) {
            throw new NullPointerException("OpCode is null");
        }
        if (messageID == null) {
            throw new NullPointerException("MessageID is null");
        }
        if (version == null) {
            throw new NullPointerException("Version is null");
        }
        this.context = context;
        this.opcode = opCode;
        this.messageId = messageID;
        this.msgVersion = version;
        Vendor vendor = messageInputStream.readVendor();
        Version version2 = messageInputStream.readVersion();
        KUID kUID = messageInputStream.readKUID();
        InetSocketAddress inetSocketAddress = messageInputStream.readSocketAddress();
        if (inetSocketAddress == null) {
            throw new UnknownHostException("Contact Address is null");
        }
        int n = messageInputStream.readUnsignedByte();
        int n2 = messageInputStream.readUnsignedByte();
        this.contact = this.createContact(socketAddress, vendor, version2, kUID, inetSocketAddress, n, n2);
        int n3 = messageInputStream.readUnsignedShort();
        messageInputStream.skip(n3);
    }

    protected abstract Contact createContact(SocketAddress var1, Vendor var2, Version var3, KUID var4, SocketAddress var5, int var6, int var7);

    public Context getContext() {
        return this.context;
    }

    public DHTMessage.OpCode getOpCode() {
        return this.opcode;
    }

    public Contact getContact() {
        return this.contact;
    }

    public MessageID getMessageID() {
        return this.messageId;
    }

    public Version getMessageVersion() {
        return this.msgVersion;
    }

    public void write(OutputStream outputStream) throws IOException {
        this.serialize();
        MessageOutputStream messageOutputStream = new MessageOutputStream(outputStream);
        this.messageId.write(messageOutputStream);
        messageOutputStream.writeByte(68);
        messageOutputStream.writeVersion(this.getMessageVersion());
        messageOutputStream.write(this.payload.length & 0xFF);
        messageOutputStream.write(this.payload.length >> 8 & 0xFF);
        messageOutputStream.write(this.payload.length >> 16 & 0xFF);
        messageOutputStream.write(this.payload.length >> 24 & 0xFF);
        messageOutputStream.write(this.payload, 0, this.payload.length);
    }

    private synchronized void serialize() throws IOException {
        if (this.payload != null) {
            return;
        }
        ByteBufferOutputStream byteBufferOutputStream = new ByteBufferOutputStream(640);
        MessageOutputStream messageOutputStream = new MessageOutputStream(byteBufferOutputStream);
        this.writeHeader(messageOutputStream);
        this.writeBody(messageOutputStream);
        messageOutputStream.close();
        this.payload = byteBufferOutputStream.toByteArray();
    }

    protected void writeHeader(MessageOutputStream messageOutputStream) throws IOException {
        messageOutputStream.writeOpCode(this.getOpCode());
        messageOutputStream.writeVendor(this.getContact().getVendor());
        messageOutputStream.writeVersion(this.getContact().getVersion());
        messageOutputStream.writeKUID(this.getContact().getNodeID());
        messageOutputStream.writeSocketAddress(this.getContact().getContactAddress());
        messageOutputStream.writeByte(this.getContact().getInstanceID());
        messageOutputStream.writeByte(this.getContact().getFlags());
        this.writeExtendedHeader(messageOutputStream);
    }

    private void writeExtendedHeader(MessageOutputStream messageOutputStream) throws IOException {
        messageOutputStream.writeShort(0);
    }

    protected abstract void writeBody(MessageOutputStream var1) throws IOException;

    protected void initSignature(Signature signature) throws SignatureException {
        try {
            SocketAddress socketAddress = this.context.getContactAddress();
            signature.update(NetworkUtils.getBytes(socketAddress, ByteOrder.BIG_ENDIAN));
            SocketAddress socketAddress2 = this.getContact().getContactAddress();
            signature.update(NetworkUtils.getBytes(socketAddress2, ByteOrder.BIG_ENDIAN));
        }
        catch (UnknownHostException unknownHostException) {
            throw new SignatureException(unknownHostException);
        }
    }

    public final int getLength() {
        try {
            this.serialize();
            return this.payload.length;
        }
        catch (IOException iOException) {
            return -1;
        }
    }
}

