/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.messages;

import java.math.BigInteger;
import java.net.SocketAddress;
import java.util.Collection;
import org.limewire.mojito.Context;
import org.limewire.mojito.KUID;
import org.limewire.mojito.db.DHTValueEntity;
import org.limewire.mojito.db.DHTValueType;
import org.limewire.mojito.messages.FindNodeRequest;
import org.limewire.mojito.messages.FindNodeResponse;
import org.limewire.mojito.messages.FindValueRequest;
import org.limewire.mojito.messages.FindValueResponse;
import org.limewire.mojito.messages.MessageFactory;
import org.limewire.mojito.messages.PingRequest;
import org.limewire.mojito.messages.PingResponse;
import org.limewire.mojito.messages.RequestMessage;
import org.limewire.mojito.messages.StatsRequest;
import org.limewire.mojito.messages.StatsResponse;
import org.limewire.mojito.messages.StoreRequest;
import org.limewire.mojito.messages.StoreResponse;
import org.limewire.mojito.messages.impl.DefaultMessageFactory;
import org.limewire.mojito.routing.Contact;
import org.limewire.security.SecurityToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageHelper {
    protected final Context context;
    private MessageFactory factory;

    public MessageHelper(Context context) {
        this.context = context;
        this.factory = new DefaultMessageFactory(context);
    }

    public void setMessageFactory(MessageFactory messageFactory) {
        if (messageFactory == null) {
            messageFactory = new DefaultMessageFactory(this.context);
        }
        this.factory = messageFactory;
    }

    public MessageFactory getMessageFactory() {
        return this.factory;
    }

    protected Contact getLocalNode() {
        return this.context.getLocalNode();
    }

    protected BigInteger getEstimatedSize() {
        return this.context.size();
    }

    public PingRequest createPingRequest(SocketAddress socketAddress) {
        return this.factory.createPingRequest(this.getLocalNode(), socketAddress);
    }

    public PingResponse createPingResponse(RequestMessage requestMessage, SocketAddress socketAddress) {
        if (this.context.getContactAddress().equals(socketAddress)) {
            throw new IllegalArgumentException("Cannot tell other Node that its external address is the same as yours!");
        }
        return this.factory.createPingResponse(this.getLocalNode(), requestMessage.getContact(), requestMessage.getMessageID(), socketAddress, this.getEstimatedSize());
    }

    public FindNodeRequest createFindNodeRequest(SocketAddress socketAddress, KUID kUID) {
        return this.factory.createFindNodeRequest(this.getLocalNode(), socketAddress, kUID);
    }

    public FindNodeResponse createFindNodeResponse(RequestMessage requestMessage, Collection<? extends Contact> collection) {
        return this.factory.createFindNodeResponse(this.getLocalNode(), requestMessage.getContact(), requestMessage.getMessageID(), collection);
    }

    public FindValueRequest createFindValueRequest(SocketAddress socketAddress, KUID kUID, Collection<KUID> collection, DHTValueType dHTValueType) {
        return this.factory.createFindValueRequest(this.getLocalNode(), socketAddress, kUID, collection, dHTValueType);
    }

    public FindValueResponse createFindValueResponse(RequestMessage requestMessage, float f, Collection<? extends DHTValueEntity> collection, Collection<KUID> collection2) {
        return this.factory.createFindValueResponse(this.getLocalNode(), requestMessage.getContact(), requestMessage.getMessageID(), f, collection, collection2);
    }

    public StoreRequest createStoreRequest(SocketAddress socketAddress, SecurityToken securityToken, Collection<? extends DHTValueEntity> collection) {
        return this.factory.createStoreRequest(this.getLocalNode(), socketAddress, securityToken, collection);
    }

    public StoreResponse createStoreResponse(RequestMessage requestMessage, Collection<StoreResponse.StoreStatusCode> collection) {
        return this.factory.createStoreResponse(this.getLocalNode(), requestMessage.getContact(), requestMessage.getMessageID(), collection);
    }

    public StatsRequest createStatsRequest(SocketAddress socketAddress, StatsRequest.StatisticType statisticType) {
        return this.factory.createStatsRequest(this.getLocalNode(), socketAddress, statisticType);
    }

    public StatsResponse createStatsResponse(RequestMessage requestMessage, byte[] byArray) {
        return this.factory.createStatsResponse(this.getLocalNode(), requestMessage.getContact(), requestMessage.getMessageID(), byArray);
    }
}

