/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.manager;

import java.util.Collection;
import org.limewire.mojito.Context;
import org.limewire.mojito.concurrent.DHTFuture;
import org.limewire.mojito.concurrent.DHTFutureTask;
import org.limewire.mojito.concurrent.DHTTask;
import org.limewire.mojito.db.DHTValueEntity;
import org.limewire.mojito.manager.AbstractManager;
import org.limewire.mojito.manager.StoreProcess;
import org.limewire.mojito.result.StoreResult;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.util.EntryImpl;
import org.limewire.security.SecurityToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreManager
extends AbstractManager<StoreResult> {
    public StoreManager(Context context) {
        super(context);
    }

    public DHTFuture<StoreResult> store(Collection<? extends DHTValueEntity> collection) {
        StoreProcess storeProcess = new StoreProcess(this.context, collection);
        StoreFuture storeFuture = new StoreFuture(storeProcess);
        this.context.getDHTExecutorService().execute(storeFuture);
        return storeFuture;
    }

    public DHTFuture<StoreResult> store(Contact contact, SecurityToken securityToken, Collection<? extends DHTValueEntity> collection) {
        EntryImpl<Contact, SecurityToken> entryImpl = new EntryImpl<Contact, SecurityToken>(contact, securityToken);
        StoreProcess storeProcess = new StoreProcess(this.context, entryImpl, collection);
        StoreFuture storeFuture = new StoreFuture(storeProcess);
        this.context.getDHTExecutorService().execute(storeFuture);
        return storeFuture;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StoreFuture
    extends DHTFutureTask<StoreResult> {
        public StoreFuture(DHTTask<StoreResult> dHTTask) {
            super(StoreManager.this.context, dHTTask);
        }
    }
}

