/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.manager;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.concurrent.OnewayExchanger;
import org.limewire.mojito.Context;
import org.limewire.mojito.KUID;
import org.limewire.mojito.handler.response.FindNodeResponseHandler;
import org.limewire.mojito.manager.BootstrapProcess;
import org.limewire.mojito.result.FindNodeResult;

class BootstrapWorker
implements Runnable {
    private static final Log LOG = LogFactory.getLog(BootstrapWorker.class);
    private final BootstrapProcess process;
    private final Context context;
    private volatile OnewayExchanger<FindNodeResult, ExecutionException> exchanger;
    private final AtomicBoolean shutdown = new AtomicBoolean();

    BootstrapWorker(Context context, BootstrapProcess bootstrapProcess) {
        this.process = bootstrapProcess;
        this.context = context;
    }

    public void run() {
        LOG.debug((Object)"starting worker");
        while (!this.shutdown.get()) {
            KUID kUID = this.process.getNextBucket();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this + " will refresh " + kUID));
            }
            if (kUID == null) {
                return;
            }
            this.refreshBucket(kUID);
        }
    }

    private void refreshBucket(KUID kUID) {
        OnewayExchanger onewayExchanger = new OnewayExchanger(true);
        FindNodeResponseHandler findNodeResponseHandler = new FindNodeResponseHandler(this.context, kUID);
        findNodeResponseHandler.start(onewayExchanger);
        this.exchanger = onewayExchanger;
        FindNodeResult findNodeResult = null;
        try {
            findNodeResult = (FindNodeResult)onewayExchanger.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (CancellationException cancellationException) {
            if (!this.shutdown.get()) {
                throw new IllegalStateException(cancellationException);
            }
        }
        catch (ExecutionException executionException) {
            LOG.info((Object)"ExecutionException", (Throwable)executionException);
            this.process.handleExecutionException(executionException);
        }
        if (findNodeResult == null) {
            return;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Finished Bucket refresh: " + findNodeResult));
        }
        this.process.refreshDone(findNodeResult.getRouteTableFailureCount(), !findNodeResult.getPath().isEmpty());
    }

    public void shutdown() {
        if (this.shutdown.getAndSet(true)) {
            return;
        }
        OnewayExchanger<FindNodeResult, ExecutionException> onewayExchanger = this.exchanger;
        if (onewayExchanger != null) {
            onewayExchanger.cancel();
        }
    }
}

