/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.io;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.mojito.Context;
import org.limewire.mojito.io.MessageDispatcher;
import org.limewire.mojito.io.Tag;
import org.limewire.mojito.messages.DHTMessage;
import org.limewire.mojito.messages.MessageFormatException;
import org.limewire.mojito.settings.NetworkSettings;
import org.limewire.security.SecureMessage;
import org.limewire.security.SecureMessageCallback;
import org.limewire.security.Verifier;

public class MessageDispatcherImpl
extends MessageDispatcher
implements Runnable {
    private static final Log LOG = LogFactory.getLog(MessageDispatcherImpl.class);
    private static final long WAIT_ON_LOCK = 5000L;
    private static final int RECEIVE_BUFFER_SIZE = NetworkSettings.RECEIVE_BUFFER_SIZE.getValue();
    private static final int SEND_BUFFER_SIZE = NetworkSettings.SEND_BUFFER_SIZE.getValue();
    private static final long SELECTOR_SLEEP = 50L;
    private volatile boolean running = false;
    private volatile boolean accepting = false;
    private Selector selector;
    private DatagramChannel channel;
    private final Object lock = new Object();
    private Thread thread;
    private final ByteBuffer receiveBuffer;
    private List<Runnable> tasks = new ArrayList<Runnable>();
    private List<Tag> outputQueue = new LinkedList<Tag>();
    private volatile boolean allocateNewByteBuffer = NetworkSettings.ALLOCATE_NEW_BUFFER.getValue();

    public MessageDispatcherImpl(Context context) {
        super(context);
        this.receiveBuffer = ByteBuffer.allocate(RECEIVE_BUFFER_SIZE);
    }

    public void setAllocateNewByteBuffer(boolean bl) {
        this.allocateNewByteBuffer = bl;
    }

    public boolean getAllocateNewByteBuffer() {
        return this.allocateNewByteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(SocketAddress socketAddress) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isBound()) {
                throw new IOException("DatagramChannel is already bound");
            }
            this.channel = DatagramChannel.open();
            this.channel.configureBlocking(false);
            this.selector = Selector.open();
            this.channel.register(this.selector, 1);
            DatagramSocket datagramSocket = this.channel.socket();
            datagramSocket.setReuseAddress(false);
            datagramSocket.setReceiveBufferSize(RECEIVE_BUFFER_SIZE);
            datagramSocket.setSendBufferSize(SEND_BUFFER_SIZE);
            datagramSocket.bind(socketAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpen() {
        Object object = this.lock;
        synchronized (object) {
            return this.channel != null && this.channel.isOpen();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBound() {
        Object object = this.lock;
        synchronized (object) {
            return this.channel != null && this.channel.socket().isBound();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatagramChannel getDatagramChannel() {
        Object object = this.lock;
        synchronized (object) {
            return this.channel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketAddress getLocalSocketAddress() {
        Object object = this.lock;
        synchronized (object) {
            if (this.channel != null && this.channel.isOpen()) {
                return this.channel.socket().getLocalSocketAddress();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isBound()) {
                throw new IllegalStateException("MessageDispatcher is not bound");
            }
            if (!this.running) {
                this.accepting = true;
                this.running = true;
                this.thread = this.context.getDHTExecutorService().getThreadFactory().newThread(this);
                this.thread.setName(this.context.getName() + "-MessageDispatcherThread");
                this.thread.setDaemon(Boolean.getBoolean("com.limegroup.mojito.io.MessageDispatcherIsDaemon"));
                this.thread.start();
                Runnable runnable = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Object object = MessageDispatcherImpl.this.lock;
                        synchronized (object) {
                            try {
                                MessageDispatcherImpl.super.start();
                            }
                            finally {
                                MessageDispatcherImpl.this.lock.notifyAll();
                            }
                        }
                    }
                };
                this.process(runnable);
                try {
                    this.lock.wait(5000L);
                }
                catch (InterruptedException interruptedException) {
                    LOG.error((Object)"InterruptedException", (Throwable)interruptedException);
                }
            }
        }
    }

    protected boolean submit(final Tag tag) {
        Runnable runnable = new Runnable(){

            public void run() {
                MessageDispatcherImpl.this.outputQueue.add(tag);
                MessageDispatcherImpl.this.interestWrite(true);
            }
        };
        this.process(runnable);
        return true;
    }

    private void handleWrite() throws IOException {
        Tag tag = null;
        while (!this.outputQueue.isEmpty()) {
            tag = this.outputQueue.get(0);
            if (tag.isCancelled()) {
                this.outputQueue.remove(0);
                continue;
            }
            try {
                SocketAddress socketAddress = tag.getSocketAddress();
                ByteBuffer byteBuffer = tag.getData();
                if (!this.send(socketAddress, byteBuffer)) break;
                this.outputQueue.remove(0);
                this.register(tag);
            }
            catch (IOException iOException) {
                LOG.error((Object)"IOException", (Throwable)iOException);
                this.outputQueue.remove(0);
                this.handleError(tag, iOException);
            }
        }
        this.interestWrite(!this.outputQueue.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            this.accepting = false;
            if (this.isRunning()) {
                Runnable runnable = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Object object = MessageDispatcherImpl.this.lock;
                        synchronized (object) {
                            try {
                                MessageDispatcherImpl.this.running = false;
                                MessageDispatcherImpl.super.stop();
                            }
                            finally {
                                MessageDispatcherImpl.this.lock.notifyAll();
                            }
                        }
                    }
                };
                this.process(runnable);
                try {
                    this.lock.wait(5000L);
                }
                catch (InterruptedException interruptedException) {
                    LOG.error((Object)"InterruptedException", (Throwable)interruptedException);
                }
                if (this.thread != null) {
                    this.thread.interrupt();
                    this.thread = null;
                }
                this.tasks.clear();
                this.outputQueue.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        super.close();
        Object object = this.lock;
        synchronized (object) {
            assert (!this.isRunning());
            if (this.selector != null) {
                try {
                    this.selector.close();
                    this.selector = null;
                }
                catch (IOException iOException) {
                    LOG.error((Object)"IOException", (Throwable)iOException);
                }
            }
            if (this.channel != null) {
                try {
                    this.channel.close();
                    this.channel = null;
                }
                catch (IOException iOException) {
                    LOG.error((Object)"IOException", (Throwable)iOException);
                }
            }
        }
    }

    public boolean isAccepting() {
        return this.accepting;
    }

    public boolean isRunning() {
        return this.running;
    }

    private void handleRead() throws IOException {
        while (this.isRunning()) {
            DHTMessage dHTMessage = null;
            try {
                dHTMessage = this.readMessage();
            }
            catch (MessageFormatException messageFormatException) {
                LOG.error((Object)"Message Format Exception: ", (Throwable)messageFormatException);
                continue;
            }
            if (dHTMessage == null) break;
            this.handleMessage(dHTMessage);
        }
        this.interestRead(true);
    }

    private DHTMessage readMessage() throws MessageFormatException, IOException {
        SocketAddress socketAddress = this.receive((ByteBuffer)this.receiveBuffer.clear());
        if (socketAddress != null) {
            this.receiveBuffer.flip();
            ByteBuffer byteBuffer = null;
            if (this.getAllocateNewByteBuffer()) {
                int n = this.receiveBuffer.remaining();
                byteBuffer = ByteBuffer.allocate(n);
                byteBuffer.put(this.receiveBuffer);
                byteBuffer.rewind();
            } else {
                byteBuffer = this.receiveBuffer.slice();
            }
            DHTMessage dHTMessage = this.deserialize(socketAddress, byteBuffer);
            return dHTMessage;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(Runnable runnable) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isRunning()) {
                this.tasks.add(runnable);
                this.selector.wakeup();
            }
        }
    }

    protected void verify(SecureMessage secureMessage, SecureMessageCallback secureMessageCallback) {
        final PublicKey publicKey = this.context.getPublicKey();
        if (publicKey == null) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Dropping SecureMessage " + secureMessage + " because PublicKey is not set"));
            }
            return;
        }
        Verifier verifier = new Verifier(secureMessage, secureMessageCallback){

            public String getAlgorithm() {
                return "SHA1withDSA";
            }

            public PublicKey getPublicKey() {
                return publicKey;
            }
        };
        this.verify(verifier);
    }

    protected void verify(Runnable runnable) {
        this.process(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interest(int n, boolean bl) {
        block7: {
            try {
                SelectionKey selectionKey = this.channel.keyFor(this.selector);
                if (selectionKey == null || !selectionKey.isValid()) break block7;
                Object object = this.channel.blockingLock();
                synchronized (object) {
                    if (bl) {
                        selectionKey.interestOps(selectionKey.interestOps() | n);
                    } else {
                        selectionKey.interestOps(selectionKey.interestOps() & ~n);
                    }
                }
            }
            catch (CancelledKeyException cancelledKeyException) {
                // empty catch block
            }
        }
    }

    private void interestRead(boolean bl) {
        this.interest(1, bl);
    }

    private void interestWrite(boolean bl) {
        this.interest(4, bl);
    }

    private SocketAddress receive(ByteBuffer byteBuffer) throws IOException {
        return this.channel.receive(byteBuffer);
    }

    private boolean send(SocketAddress socketAddress, ByteBuffer byteBuffer) throws IOException {
        return this.channel.send(byteBuffer, socketAddress) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAll() {
        List<Runnable> list = null;
        Iterator<Runnable> iterator = this.lock;
        synchronized (iterator) {
            list = this.tasks;
            this.tasks = new ArrayList<Runnable>();
        }
        for (Runnable runnable : list) {
            runnable.run();
        }
    }

    public void run() {
        try {
            while (true) {
                this.processAll();
                if (!this.isRunning() || !this.isOpen()) break;
                this.selector.select(50L);
                try {
                    this.handleRead();
                }
                catch (IOException iOException) {
                    LOG.error((Object)"IOException-READ", (Throwable)iOException);
                }
                try {
                    this.handleWrite();
                }
                catch (IOException iOException) {
                    LOG.error((Object)"IOException-WRITE", (Throwable)iOException);
                }
            }
        }
        catch (IOException iOException) {
            Thread.currentThread().getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), iOException);
        }
    }
}

