/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.handler.response;

import java.io.IOException;
import java.io.Serializable;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.mojito.Context;
import org.limewire.mojito.KUID;
import org.limewire.mojito.db.DHTValueEntity;
import org.limewire.mojito.db.Database;
import org.limewire.mojito.exceptions.DHTException;
import org.limewire.mojito.handler.ResponseHandler;
import org.limewire.mojito.handler.response.AbstractResponseHandler;
import org.limewire.mojito.messages.RequestMessage;
import org.limewire.mojito.messages.ResponseMessage;
import org.limewire.mojito.messages.StoreRequest;
import org.limewire.mojito.messages.StoreResponse;
import org.limewire.mojito.result.StoreResult;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.settings.KademliaSettings;
import org.limewire.mojito.settings.StoreSettings;
import org.limewire.mojito.util.CollectionUtils;
import org.limewire.security.SecurityToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreResponseHandler
extends AbstractResponseHandler<StoreResult> {
    private static final Log LOG = LogFactory.getLog(StoreResponseHandler.class);
    private final Collection<? extends DHTValueEntity> entities;
    private final List<StoreProcess> processes = new ArrayList<StoreProcess>();
    private Iterator<StoreProcess> toProcess = null;
    private Map<KUID, StoreProcess> activeProcesses = new HashMap<KUID, StoreProcess>();
    private final int parallelism = StoreSettings.PARALLEL_STORES.getValue();

    public StoreResponseHandler(Context context, Collection<? extends Map.Entry<? extends Contact, ? extends SecurityToken>> collection, Collection<? extends DHTValueEntity> collection2) {
        super(context);
        this.entities = collection2;
        if (collection.size() > KademliaSettings.REPLICATION_PARAMETER.getValue() && LOG.isWarnEnabled()) {
            LOG.warn((Object)("Path is longer than K: " + collection.size() + " > " + KademliaSettings.REPLICATION_PARAMETER.getValue()));
        }
        for (Map.Entry<? extends Contact, ? extends SecurityToken> entry : collection) {
            Contact contact = entry.getKey();
            SecurityToken securityToken = entry.getValue();
            if (context.isLocalNode(contact)) {
                this.processes.add(new LocalStoreProcess(contact, securityToken, collection2));
                continue;
            }
            this.processes.add(new RemoteStoreProcess(contact, securityToken, collection2));
        }
    }

    @Override
    public void start() throws DHTException {
        this.toProcess = this.processes.iterator();
        this.sendNextAndExitIfDone();
    }

    @Override
    protected void response(ResponseMessage responseMessage, long l) throws IOException {
        Contact contact = responseMessage.getContact();
        KUID kUID = contact.getNodeID();
        StoreProcess storeProcess = this.activeProcesses.get(kUID);
        if (storeProcess != null && storeProcess.response(responseMessage)) {
            this.activeProcesses.remove(kUID);
        }
        this.sendNextAndExitIfDone();
    }

    @Override
    protected void timeout(KUID kUID, SocketAddress socketAddress, RequestMessage requestMessage, long l) throws IOException {
        StoreProcess storeProcess = this.activeProcesses.get(kUID);
        if (storeProcess != null && storeProcess.timeout(requestMessage, l)) {
            this.activeProcesses.remove(kUID);
        }
        this.sendNextAndExitIfDone();
    }

    @Override
    protected void error(KUID kUID, SocketAddress socketAddress, RequestMessage requestMessage, IOException iOException) {
        StoreProcess storeProcess = this.activeProcesses.get(kUID);
        if (storeProcess != null && storeProcess.error(requestMessage, iOException)) {
            this.activeProcesses.remove(kUID);
        }
        this.sendNextAndExitIfDone();
    }

    private void sendNextAndExitIfDone() {
        while (this.activeProcesses.size() < this.parallelism && this.toProcess.hasNext()) {
            StoreProcess storeProcess = this.toProcess.next();
            try {
                boolean bl = storeProcess.store();
                if (bl) continue;
                Contact contact = storeProcess.getContact();
                this.activeProcesses.put(contact.getNodeID(), storeProcess);
            }
            catch (IOException iOException) {
                storeProcess.setIOException(iOException);
                storeProcess.finish();
                LOG.error((Object)"IOException", (Throwable)iOException);
            }
        }
        if (this.activeProcesses.isEmpty()) {
            this.done();
        }
    }

    private void done() {
        Object object;
        Serializable serializable;
        LinkedHashMap<Contact, Collection<StoreResponse.StoreStatusCode>> linkedHashMap = new LinkedHashMap<Contact, Collection<StoreResponse.StoreStatusCode>>();
        HashMap<SocketAddress, ArrayList<Contact>> hashMap = new HashMap<SocketAddress, ArrayList<Contact>>();
        for (StoreProcess object2 : this.processes) {
            Contact l = object2.getContact();
            Collection<StoreResponse.StoreStatusCode> collection = object2.getStoreStatusCodes();
            linkedHashMap.put(l, collection);
            for (StoreResponse.StoreStatusCode storeStatusCode : collection) {
                if (!storeStatusCode.getStatusCode().equals(StoreResponse.OK)) continue;
                serializable = storeStatusCode.getSecondaryKey();
                ArrayList<Contact> arrayList = (ArrayList<Contact>)hashMap.get(serializable);
                if (arrayList == null) {
                    arrayList = new ArrayList<Contact>();
                    hashMap.put((SocketAddress)serializable, arrayList);
                }
                arrayList.add(l);
            }
        }
        if (this.processes.size() == 1) {
            object = this.processes.get(0);
            IOException iOException = ((StoreProcess)object).getIOException();
            long l = ((StoreProcess)object).getTimeout();
            if (iOException != null) {
                this.setException(new DHTException(iOException));
                return;
            }
            if (l != -1L) {
                Contact contact = ((StoreProcess)object).getContact();
                KUID kUID = contact.getNodeID();
                serializable = contact.getContactAddress();
                this.fireTimeoutException(kUID, (SocketAddress)serializable, null, l);
                return;
            }
        }
        object = new StoreResult(linkedHashMap, this.entities);
        this.setReturnValue(object);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RemoteStoreProcess
    extends StoreProcess {
        private DHTValueEntity currentEntity;

        private RemoteStoreProcess(Contact contact, SecurityToken securityToken, Collection<? extends DHTValueEntity> collection) {
            super(contact, securityToken, collection);
            this.currentEntity = null;
        }

        @Override
        public boolean store() throws IOException {
            this.currentEntity = null;
            if (!this.hasNext()) {
                return true;
            }
            this.currentEntity = this.next();
            StoreRequest storeRequest = StoreResponseHandler.this.context.getMessageHelper().createStoreRequest(this.getContact().getContactAddress(), this.getSecurityToken(), Collections.singleton(this.currentEntity));
            StoreResponseHandler.this.context.getMessageDispatcher().send(this.getContact(), (RequestMessage)storeRequest, (ResponseHandler)StoreResponseHandler.this);
            return false;
        }

        @Override
        public boolean response(ResponseMessage responseMessage) throws IOException {
            StoreResponse storeResponse = (StoreResponse)responseMessage;
            Collection<StoreResponse.StoreStatusCode> collection = storeResponse.getStoreStatusCodes();
            if (collection.size() != 1) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)(this.getContact() + " sent a wrong number of StoreStatusCodes: " + collection));
                }
                this.finish();
                return true;
            }
            StoreResponse.StoreStatusCode storeStatusCode = collection.iterator().next();
            if (!storeStatusCode.isFor(this.currentEntity)) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)(this.getContact() + " sent a wrong [" + storeStatusCode + "] for " + this.currentEntity + "\n" + CollectionUtils.toString(this.getEntities())));
                }
                this.finish();
                return true;
            }
            return this.store();
        }

        @Override
        public boolean error(RequestMessage requestMessage, IOException iOException) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("Couldn't store " + this.currentEntity + " at " + this.getContact()), (Throwable)iOException);
            }
            this.setIOException(iOException);
            this.addStoreStatusCode(new StoreResponse.StoreStatusCode(this.currentEntity, StoreResponse.ERROR));
            try {
                return this.store();
            }
            catch (IOException iOException2) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"IOException", (Throwable)iOException2);
                }
                this.finish();
                return true;
            }
        }

        @Override
        public boolean timeout(RequestMessage requestMessage, long l) throws IOException {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Couldn't store " + this.currentEntity + " at " + this.getContact()));
            }
            this.setTimeout(l);
            this.addStoreStatusCode(new StoreResponse.StoreStatusCode(this.currentEntity, StoreResponse.ERROR));
            return this.store();
        }

        @Override
        public void finish() {
            if (this.currentEntity != null) {
                this.addStoreStatusCode(new StoreResponse.StoreStatusCode(this.currentEntity, StoreResponse.ERROR));
                this.currentEntity = null;
            }
            super.finish();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LocalStoreProcess
    extends StoreProcess {
        private LocalStoreProcess(Contact contact, SecurityToken securityToken, Collection<? extends DHTValueEntity> collection) {
            super(contact, securityToken, collection);
        }

        @Override
        public boolean store() throws IOException {
            Database database = StoreResponseHandler.this.context.getDatabase();
            while (this.hasNext()) {
                DHTValueEntity dHTValueEntity = this.next();
                boolean bl = database.store(dHTValueEntity);
                if (bl) {
                    this.addStoreStatusCode(new StoreResponse.StoreStatusCode(dHTValueEntity, StoreResponse.OK));
                    continue;
                }
                this.addStoreStatusCode(new StoreResponse.StoreStatusCode(dHTValueEntity, StoreResponse.ERROR));
            }
            return true;
        }

        @Override
        public boolean response(ResponseMessage responseMessage) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean error(RequestMessage requestMessage, IOException iOException) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean timeout(RequestMessage requestMessage, long l) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class StoreProcess {
        private final Contact node;
        private final SecurityToken securityToken;
        private final Collection<? extends DHTValueEntity> entities;
        private final Iterator<? extends DHTValueEntity> iterator;
        private final Collection<StoreResponse.StoreStatusCode> codes = new ArrayList<StoreResponse.StoreStatusCode>();
        private IOException exception;
        private long timeout = -1L;

        private StoreProcess(Contact contact, SecurityToken securityToken, Collection<? extends DHTValueEntity> collection) {
            this.node = contact;
            this.securityToken = securityToken;
            this.entities = collection;
            this.iterator = collection.iterator();
        }

        public Contact getContact() {
            return this.node;
        }

        public SecurityToken getSecurityToken() {
            return this.securityToken;
        }

        public Collection<? extends DHTValueEntity> getEntities() {
            return this.entities;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public DHTValueEntity next() {
            return this.iterator.next();
        }

        public void addStoreStatusCode(StoreResponse.StoreStatusCode storeStatusCode) {
            this.codes.add(storeStatusCode);
        }

        public Collection<StoreResponse.StoreStatusCode> getStoreStatusCodes() {
            return this.codes;
        }

        public void setIOException(IOException iOException) {
            this.exception = iOException;
        }

        public IOException getIOException() {
            return this.exception;
        }

        public void setTimeout(long l) {
            this.timeout = l;
        }

        public long getTimeout() {
            return this.timeout;
        }

        public void finish() {
            while (this.hasNext()) {
                DHTValueEntity dHTValueEntity = this.next();
                this.addStoreStatusCode(new StoreResponse.StoreStatusCode(dHTValueEntity, StoreResponse.ERROR));
            }
        }

        public abstract boolean store() throws IOException;

        public abstract boolean response(ResponseMessage var1) throws IOException;

        public abstract boolean error(RequestMessage var1, IOException var2);

        public abstract boolean timeout(RequestMessage var1, long var2) throws IOException;
    }
}

