/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.handler.response;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.mojito.Context;
import org.limewire.mojito.EntityKey;
import org.limewire.mojito.KUID;
import org.limewire.mojito.db.DHTValueEntity;
import org.limewire.mojito.handler.response.LookupResponseHandler;
import org.limewire.mojito.messages.FindNodeResponse;
import org.limewire.mojito.messages.FindValueResponse;
import org.limewire.mojito.messages.LookupRequest;
import org.limewire.mojito.messages.RequestMessage;
import org.limewire.mojito.messages.ResponseMessage;
import org.limewire.mojito.result.FindValueResult;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.settings.LookupSettings;
import org.limewire.mojito.statistics.FindValueLookupStatisticContainer;
import org.limewire.mojito.util.DatabaseUtils;
import org.limewire.security.SecurityToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindValueResponseHandler
extends LookupResponseHandler<FindValueResult> {
    private static final Log LOG = LogFactory.getLog(FindValueResponseHandler.class);
    private boolean exchaustive = false;
    private final FindValueLookupStatisticContainer lookupStat;
    private final EntityKey lookupKey;
    private final Collection<EntityKey> entityKeys = new ArrayList<EntityKey>();
    private final Collection<DHTValueEntity> entities = new ArrayList<DHTValueEntity>();

    public FindValueResponseHandler(Context context, EntityKey entityKey) {
        super(context, entityKey.getPrimaryKey());
        this.lookupKey = entityKey;
        this.setExhaustive(LookupSettings.EXHAUSTIVE_VALUE_LOOKUP.getValue());
        this.lookupStat = new FindValueLookupStatisticContainer(context, this.lookupId);
    }

    @Override
    protected void response(ResponseMessage responseMessage, long l) throws IOException {
        super.response(responseMessage, l);
        this.lookupStat.addReply();
    }

    @Override
    protected void timeout(KUID kUID, SocketAddress socketAddress, RequestMessage requestMessage, long l) throws IOException {
        super.timeout(kUID, socketAddress, requestMessage, l);
        this.lookupStat.addTimeout();
    }

    @Override
    protected boolean lookup(Contact contact) throws IOException {
        if (super.lookup(contact)) {
            this.lookupStat.addRequest();
            return true;
        }
        return false;
    }

    public void setExhaustive(boolean bl) {
        this.exchaustive = bl;
    }

    @Override
    protected void finishLookup() {
        long l = this.getElapsedTime();
        int n = this.getCurrentHop();
        Map<Contact, SecurityToken> map = this.getPath();
        Collection<DHTValueEntity> collection = this.getDHTValueEntities();
        Collection<EntityKey> collection2 = this.getEntityKeys();
        if (collection.isEmpty() && collection2.isEmpty()) {
            this.lookupStat.FIND_VALUE_FAILURE.incrementStat();
        } else {
            this.lookupStat.FIND_VALUE_OK.incrementStat();
        }
        this.lookupStat.setHops(n, true);
        this.lookupStat.setTime((int)l, true);
        this.setReturnValue(new FindValueResult(this.lookupKey, map, collection, collection2, l, n));
    }

    public EntityKey getLookupKey() {
        return this.lookupKey;
    }

    public Collection<DHTValueEntity> getDHTValueEntities() {
        return this.entities;
    }

    public Collection<EntityKey> getEntityKeys() {
        return this.entityKeys;
    }

    @Override
    protected boolean nextStep(ResponseMessage responseMessage) throws IOException {
        if (responseMessage instanceof FindNodeResponse) {
            return this.handleNodeResponse((FindNodeResponse)responseMessage);
        }
        if (!(responseMessage instanceof FindValueResponse)) {
            throw new IllegalArgumentException("this is a find value handler");
        }
        FindValueResponse findValueResponse = (FindValueResponse)responseMessage;
        if (!this.extractDataFromResponse(findValueResponse)) {
            return false;
        }
        this.addToResponsePath(findValueResponse);
        if (!this.exchaustive) {
            this.killActiveSearches();
            return false;
        }
        return true;
    }

    @Override
    protected int getDefaultParallelism() {
        return LookupSettings.FIND_VALUE_PARALLEL_LOOKUPS.getValue();
    }

    @Override
    protected boolean isTimeout(long l) {
        long l2 = LookupSettings.FIND_VALUE_LOOKUP_TIMEOUT.getValue();
        return l2 > 0L && l >= l2;
    }

    @Override
    protected LookupRequest createLookupRequest(Contact contact) {
        Set<KUID> set = Collections.emptySet();
        return this.context.getMessageHelper().createFindValueRequest(contact.getContactAddress(), this.lookupId, set, this.lookupKey.getDHTValueType());
    }

    private boolean extractDataFromResponse(FindValueResponse findValueResponse) {
        Contact contact = findValueResponse.getContact();
        Collection<KUID> collection = findValueResponse.getSecondaryKeys();
        Collection<? extends DHTValueEntity> collection2 = findValueResponse.getDHTValueEntities();
        if (collection.isEmpty() && collection2.isEmpty()) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)(contact + " returned neither keys nor values for " + this.lookupId));
            }
            return false;
        }
        Collection<? extends DHTValueEntity> collection3 = DatabaseUtils.filter(this.lookupKey.getDHTValueType(), collection2);
        if (collection3.isEmpty() && !collection2.isEmpty()) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)(contact + " returned unrequested types of values for " + this.lookupId));
            }
            return false;
        }
        this.entities.addAll(collection3);
        for (KUID kUID : collection) {
            EntityKey entityKey = EntityKey.createEntityKey(contact, this.lookupId, kUID, this.lookupKey.getDHTValueType());
            this.entityKeys.add(entityKey);
        }
        return true;
    }
}

