/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.handler.response;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.concurrent.OnewayExchanger;
import org.limewire.mojito.Context;
import org.limewire.mojito.KUID;
import org.limewire.mojito.concurrent.DHTTask;
import org.limewire.mojito.exceptions.DHTException;
import org.limewire.mojito.exceptions.DHTTimeoutException;
import org.limewire.mojito.handler.ResponseHandler;
import org.limewire.mojito.messages.RequestMessage;
import org.limewire.mojito.messages.ResponseMessage;
import org.limewire.mojito.result.Result;
import org.limewire.mojito.settings.ContextSettings;
import org.limewire.mojito.settings.NetworkSettings;
import org.limewire.mojito.util.ContactUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResponseHandler<V extends Result>
implements ResponseHandler,
DHTTask<V> {
    private static final Log LOG = LogFactory.getLog(AbstractResponseHandler.class);
    private int errors = 0;
    private long elapsedTime;
    private long timeout;
    private int maxErrors;
    protected final Context context;
    private volatile OnewayExchanger<V, ExecutionException> exchanger;
    protected long lastResponseTime = 0L;

    public AbstractResponseHandler(Context context) {
        this(context, -1L, -1);
    }

    public AbstractResponseHandler(Context context, long l) {
        this(context, l, -1);
    }

    public AbstractResponseHandler(Context context, int n) {
        this(context, -1L, n);
    }

    public AbstractResponseHandler(Context context, long l, int n) {
        this.context = context;
        this.setTimeout(l);
        this.setMaxErrors(n);
    }

    protected Object getLock() {
        OnewayExchanger<V, ExecutionException> onewayExchanger = this.exchanger;
        if (onewayExchanger == null) {
            throw new IllegalStateException("Lock is null");
        }
        return onewayExchanger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(OnewayExchanger<V, ExecutionException> onewayExchanger) {
        if (onewayExchanger == null) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"Starting ResponseHandler without an OnewayExchanger");
            }
            onewayExchanger = new OnewayExchanger(true);
        }
        this.exchanger = onewayExchanger;
        Object object = this.getLock();
        synchronized (object) {
            if (this.isDone() || this.isCancelled()) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Cannot start " + this + " because it's already done"));
                }
                return;
            }
            try {
                this.start();
            }
            catch (DHTException dHTException) {
                this.setException(dHTException);
            }
        }
    }

    protected abstract void start() throws DHTException;

    @Override
    public void cancel() {
        this.exchanger.cancel();
    }

    public void setTimeout(long l) {
        this.timeout = l < 0L ? NetworkSettings.DEFAULT_TIMEOUT.getValue() : l;
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    protected long getElapsedTime() {
        return this.elapsedTime;
    }

    protected long getLastResponseTime() {
        return this.lastResponseTime;
    }

    protected void resetErrors() {
        this.errors = 0;
    }

    protected int getErrors() {
        return this.errors;
    }

    public void setMaxErrors(int n) {
        this.maxErrors = n < 0 ? NetworkSettings.MAX_ERRORS.getValue() : n;
    }

    public int getMaxErrors() {
        return this.maxErrors;
    }

    @Override
    public long getWaitOnLockTimeout() {
        return ContextSettings.getWaitOnLock(this.getTimeout());
    }

    protected abstract void response(ResponseMessage var1, long var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleResponse(ResponseMessage responseMessage, long l) throws IOException {
        Object object = this.getLock();
        synchronized (object) {
            if (this.isCancelled() || this.isDone()) {
                return;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Received " + responseMessage + " from " + responseMessage.getContact() + " after " + this.getErrors() + " errors and a total time of " + this.getElapsedTime() + "ms"));
            }
            this.elapsedTime += l;
            this.lastResponseTime = System.currentTimeMillis();
            this.response(responseMessage, l);
        }
    }

    protected abstract void timeout(KUID var1, SocketAddress var2, RequestMessage var3, long var4) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleTimeout(KUID kUID, SocketAddress socketAddress, RequestMessage requestMessage, long l) throws IOException {
        Object object = this.getLock();
        synchronized (object) {
            if (this.isCancelled() || this.isDone()) {
                return;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)(requestMessage + " to " + ContactUtils.toString(kUID, socketAddress) + " failed after " + l + "ms"));
            }
            this.elapsedTime += l;
            try {
                if (this.errors < this.maxErrors) {
                    this.resend(kUID, socketAddress, requestMessage);
                } else {
                    this.timeout(kUID, socketAddress, requestMessage, this.getElapsedTime());
                }
            }
            finally {
                ++this.errors;
            }
        }
    }

    protected void resend(KUID kUID, SocketAddress socketAddress, RequestMessage requestMessage) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Re-sending " + requestMessage + " to " + ContactUtils.toString(kUID, socketAddress)));
        }
        this.context.getMessageDispatcher().send(kUID, socketAddress, requestMessage, this);
    }

    protected abstract void error(KUID var1, SocketAddress var2, RequestMessage var3, IOException var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleError(KUID kUID, SocketAddress socketAddress, RequestMessage requestMessage, IOException iOException) {
        Object object = this.getLock();
        synchronized (object) {
            if (this.isCancelled() || this.isDone()) {
                return;
            }
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("Sending a " + requestMessage + " to " + ContactUtils.toString(kUID, socketAddress) + " failed"), (Throwable)iOException);
            }
            this.error(kUID, socketAddress, requestMessage, iOException);
        }
    }

    protected void tick() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleTick() {
        Object object = this.getLock();
        synchronized (object) {
            if (this.isCancelled() || this.isDone()) {
                return;
            }
            this.tick();
        }
    }

    @Override
    public boolean isCancelled() {
        return this.exchanger.isCancelled();
    }

    public boolean isDone() {
        return this.exchanger.isDone();
    }

    protected void setReturnValue(V v) {
        this.exchanger.setValue(v);
    }

    protected void setException(DHTException dHTException) {
        ExecutionException executionException = new ExecutionException(dHTException);
        executionException.setStackTrace(dHTException.getStackTrace());
        this.exchanger.setException(executionException);
    }

    protected void fireTimeoutException(KUID kUID, SocketAddress socketAddress, RequestMessage requestMessage, long l) {
        this.setException(this.createTimeoutException(kUID, socketAddress, requestMessage, l));
    }

    protected DHTTimeoutException createTimeoutException(KUID kUID, SocketAddress socketAddress, RequestMessage requestMessage, long l) {
        return new DHTTimeoutException(kUID, socketAddress, requestMessage, l);
    }
}

