/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.db.impl;

import java.util.Collection;
import java.util.Map;
import org.limewire.mojito.KUID;
import org.limewire.mojito.db.DHTValueEntity;
import org.limewire.mojito.db.Database;
import org.limewire.mojito.db.DatabaseSecurityConstraint;
import org.limewire.mojito.settings.DatabaseSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDatabaseSecurityConstraint
implements DatabaseSecurityConstraint {
    private static final long serialVersionUID = 4513377023367562179L;

    @Override
    public boolean allowStore(Database database, Map<KUID, DHTValueEntity> map, DHTValueEntity dHTValueEntity) {
        if (dHTValueEntity.isLocalValue()) {
            return true;
        }
        int n = DatabaseSettings.MAX_DATABASE_SIZE.getValue();
        int n2 = DatabaseSettings.MAX_VALUES_PER_KEY.getValue();
        if (map == null) {
            return n < 0 || database.getKeyCount() < n;
        }
        DHTValueEntity dHTValueEntity2 = map.get(dHTValueEntity.getSecondaryKey());
        if (dHTValueEntity2 == null) {
            if (n2 < 0 || map.size() < n2) {
                return true;
            }
            if (dHTValueEntity.getCreator().isFirewalled()) {
                return false;
            }
            DHTValueEntity dHTValueEntity3 = this.getOldestFirewalledValue(map.values());
            if (dHTValueEntity3 != null) {
                database.remove(dHTValueEntity3.getPrimaryKey(), dHTValueEntity3.getSecondaryKey());
                return true;
            }
            return false;
        }
        return this.allowReplace(database, map, dHTValueEntity2, dHTValueEntity);
    }

    private boolean allowReplace(Database database, Map<KUID, DHTValueEntity> map, DHTValueEntity dHTValueEntity, DHTValueEntity dHTValueEntity2) {
        if (dHTValueEntity.isLocalValue() && !dHTValueEntity2.isLocalValue()) {
            return false;
        }
        if (dHTValueEntity.isDirect() && !dHTValueEntity2.isDirect()) {
            return false;
        }
        return dHTValueEntity2.isDirect() || dHTValueEntity2.getValue().size() != 0;
    }

    private DHTValueEntity getOldestFirewalledValue(Collection<DHTValueEntity> collection) {
        DHTValueEntity dHTValueEntity = null;
        for (DHTValueEntity dHTValueEntity2 : collection) {
            if (dHTValueEntity2.isLocalValue() || !dHTValueEntity2.getCreator().isFirewalled() || dHTValueEntity != null && dHTValueEntity2.getCreationTime() >= dHTValueEntity.getCreationTime()) continue;
            dHTValueEntity = dHTValueEntity2;
        }
        return dHTValueEntity;
    }
}

