/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.db.impl;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.IntHashMap;
import org.limewire.io.NetworkUtils;
import org.limewire.mojito.KUID;
import org.limewire.mojito.db.DHTValueEntity;
import org.limewire.mojito.db.Database;
import org.limewire.mojito.db.DatabaseSecurityConstraint;
import org.limewire.mojito.db.impl.DHTValueEntityBag;
import org.limewire.mojito.db.impl.DefaultDatabaseSecurityConstraint;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.settings.DatabaseSettings;
import org.limewire.mojito.util.ContactUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseImpl
implements Database {
    private static final long serialVersionUID = -4857315774747734947L;
    private static final Log LOG = LogFactory.getLog(DatabaseImpl.class);
    public static final int IPV4_ADDRESS_NETMASK = -1;
    private final Map<KUID, DHTValueEntityBag> database = new HashMap<KUID, DHTValueEntityBag>();
    private volatile DatabaseSecurityConstraint securityConstraint = new DefaultDatabaseSecurityConstraint();
    private final IntHashMap<AtomicInteger> valuesPerNetwork = new IntHashMap();
    private final IntHashMap<AtomicInteger> valuesPerAddress = new IntHashMap();

    @Override
    public void setDatabaseSecurityConstraint(DatabaseSecurityConstraint databaseSecurityConstraint) {
        if (databaseSecurityConstraint == null) {
            databaseSecurityConstraint = new DefaultDatabaseSecurityConstraint();
        }
        this.securityConstraint = databaseSecurityConstraint;
    }

    @Override
    public synchronized int getKeyCount() {
        return this.database.size();
    }

    @Override
    public synchronized int getValueCount() {
        return this.values().size();
    }

    @Override
    public synchronized void clear() {
        this.database.clear();
    }

    @Override
    public synchronized boolean store(DHTValueEntity dHTValueEntity) {
        if (!this.allowStore(dHTValueEntity)) {
            return false;
        }
        if (dHTValueEntity.getValue().size() == 0) {
            return this.remove(dHTValueEntity.getPrimaryKey(), dHTValueEntity.getSecondaryKey()) != null;
        }
        return this.add(dHTValueEntity);
    }

    public synchronized boolean add(DHTValueEntity dHTValueEntity) {
        KUID kUID = dHTValueEntity.getPrimaryKey();
        DHTValueEntityBag dHTValueEntityBag = this.database.get(kUID);
        if (dHTValueEntityBag == null) {
            dHTValueEntityBag = new DHTValueEntityBag(this, kUID);
        }
        if (dHTValueEntityBag.add(dHTValueEntity)) {
            if (!this.database.containsKey(kUID)) {
                this.database.put(kUID, dHTValueEntityBag);
            }
            this.incrementValuesPerAddress(dHTValueEntity);
            this.incrementValuesPerNetwork(dHTValueEntity);
            return true;
        }
        return false;
    }

    @Override
    public synchronized DHTValueEntity remove(KUID kUID, KUID kUID2) {
        DHTValueEntity dHTValueEntity = null;
        DHTValueEntityBag dHTValueEntityBag = this.database.get(kUID);
        if (dHTValueEntityBag != null && (dHTValueEntity = dHTValueEntityBag.remove(kUID2)) != null) {
            if (dHTValueEntityBag.isEmpty()) {
                this.database.remove(kUID);
            }
            this.decrementValuesPerAddress(dHTValueEntity);
            this.decrementValuesPerNetwork(dHTValueEntity);
        }
        return dHTValueEntity;
    }

    public synchronized int getValuesPerNetwork(DHTValueEntity dHTValueEntity) {
        return DatabaseImpl.getValueCount(dHTValueEntity, this.valuesPerNetwork, -256);
    }

    public synchronized int getValuesPerAddress(DHTValueEntity dHTValueEntity) {
        return DatabaseImpl.getValueCount(dHTValueEntity, this.valuesPerAddress, -1);
    }

    private static int getValueCount(DHTValueEntity dHTValueEntity, IntHashMap<AtomicInteger> intHashMap, int n) {
        int n2;
        AtomicInteger atomicInteger;
        if (dHTValueEntity.isLocalValue()) {
            return 0;
        }
        Contact contact = dHTValueEntity.getCreator();
        InetAddress inetAddress = ((InetSocketAddress)contact.getContactAddress()).getAddress();
        if (inetAddress instanceof Inet4Address && (atomicInteger = intHashMap.get(n2 = NetworkUtils.getMaskedIP(inetAddress, n))) != null) {
            return atomicInteger.get();
        }
        return 0;
    }

    private int incrementValuesPerNetwork(DHTValueEntity dHTValueEntity) {
        return DatabaseImpl.incrementValueCount(dHTValueEntity, this.valuesPerNetwork, -256);
    }

    private int incrementValuesPerAddress(DHTValueEntity dHTValueEntity) {
        return DatabaseImpl.incrementValueCount(dHTValueEntity, this.valuesPerAddress, -1);
    }

    private static int incrementValueCount(DHTValueEntity dHTValueEntity, IntHashMap<AtomicInteger> intHashMap, int n) {
        if (dHTValueEntity.isLocalValue()) {
            return 0;
        }
        Contact contact = dHTValueEntity.getCreator();
        InetAddress inetAddress = ((InetSocketAddress)contact.getContactAddress()).getAddress();
        if (inetAddress instanceof Inet4Address) {
            int n2 = NetworkUtils.getMaskedIP(inetAddress, n);
            AtomicInteger atomicInteger = intHashMap.get(n2);
            if (atomicInteger == null) {
                atomicInteger = new AtomicInteger(0);
                intHashMap.put(n2, atomicInteger);
            }
            return atomicInteger.incrementAndGet();
        }
        return 0;
    }

    private int decrementValuesPerNetwork(DHTValueEntity dHTValueEntity) {
        return DatabaseImpl.decrementValueCount(dHTValueEntity, this.valuesPerNetwork, -256);
    }

    private int decrementValuesPerAddress(DHTValueEntity dHTValueEntity) {
        return DatabaseImpl.decrementValueCount(dHTValueEntity, this.valuesPerAddress, -1);
    }

    private static int decrementValueCount(DHTValueEntity dHTValueEntity, IntHashMap<AtomicInteger> intHashMap, int n) {
        int n2;
        AtomicInteger atomicInteger;
        if (dHTValueEntity.isLocalValue()) {
            return 0;
        }
        Contact contact = dHTValueEntity.getCreator();
        InetAddress inetAddress = ((InetSocketAddress)contact.getContactAddress()).getAddress();
        if (inetAddress instanceof Inet4Address && (atomicInteger = intHashMap.get(n2 = NetworkUtils.getMaskedIP(inetAddress, n))) != null) {
            int n3 = atomicInteger.decrementAndGet();
            if (n3 == 0) {
                intHashMap.remove(n2);
            }
            return n3;
        }
        return 0;
    }

    @Override
    public synchronized float getRequestLoad(KUID kUID, boolean bl) {
        DHTValueEntityBag dHTValueEntityBag = this.database.get(kUID);
        if (dHTValueEntityBag != null) {
            return dHTValueEntityBag.getRequestLoad(bl);
        }
        return 0.0f;
    }

    private boolean allowStore(DHTValueEntity dHTValueEntity) {
        if (dHTValueEntity.isLocalValue()) {
            return true;
        }
        if (DatabaseSettings.VALIDATE_VALUE_CREATOR.getValue() && !dHTValueEntity.isDirect()) {
            if (!ContactUtils.isValidSocketAddress(dHTValueEntity.getCreator())) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("The Creator of " + dHTValueEntity + " has an invalid address"));
                }
                return false;
            }
            if (ContactUtils.isPrivateAddress(dHTValueEntity.getCreator())) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("The Creator of " + dHTValueEntity + " has a private address"));
                }
                return false;
            }
        }
        if (dHTValueEntity.getValue().size() != 0) {
            int n = this.getValuesPerAddress(dHTValueEntity);
            if (DatabaseSettings.LIMIT_VALUES_PER_ADDRESS.getValue() && n >= DatabaseSettings.MAX_VALUES_PER_ADDRESS.getValue()) {
                return false;
            }
            int n2 = this.getValuesPerNetwork(dHTValueEntity);
            if (DatabaseSettings.LIMIT_VALUES_PER_NETWORK.getValue() && n2 >= DatabaseSettings.MAX_VALUES_PER_NETWORK.getValue()) {
                return false;
            }
        }
        DHTValueEntityBag dHTValueEntityBag = this.database.get(dHTValueEntity.getPrimaryKey());
        DatabaseSecurityConstraint databaseSecurityConstraint = this.securityConstraint;
        if (databaseSecurityConstraint != null && dHTValueEntityBag != null) {
            return databaseSecurityConstraint.allowStore(this, dHTValueEntityBag.getValues(false), dHTValueEntity);
        }
        return true;
    }

    public synchronized DHTValueEntityBag getBag(KUID kUID) {
        return this.database.get(kUID);
    }

    @Override
    public synchronized Map<KUID, DHTValueEntity> get(KUID kUID) {
        DHTValueEntityBag dHTValueEntityBag = this.database.get(kUID);
        if (dHTValueEntityBag != null) {
            return dHTValueEntityBag.getValues(true);
        }
        return Collections.emptyMap();
    }

    @Override
    public synchronized boolean contains(KUID kUID, KUID kUID2) {
        DHTValueEntityBag dHTValueEntityBag = this.database.get(kUID);
        return dHTValueEntityBag != null && dHTValueEntityBag.contains(kUID2);
    }

    @Override
    public synchronized Set<KUID> keySet() {
        return new HashSet<KUID>(this.database.keySet());
    }

    @Override
    public synchronized Collection<DHTValueEntity> values() {
        ArrayList<DHTValueEntity> arrayList = new ArrayList<DHTValueEntity>(this.getKeyCount() * 2);
        for (DHTValueEntityBag dHTValueEntityBag : this.database.values()) {
            arrayList.addAll(dHTValueEntityBag.getValues(false).values());
        }
        return arrayList;
    }

    public synchronized String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (DHTValueEntityBag dHTValueEntityBag : this.database.values()) {
            stringBuilder.append(dHTValueEntityBag.toString());
        }
        stringBuilder.append("-------------\n");
        stringBuilder.append("TOTAL: ").append(this.getKeyCount()).append("/").append(this.getValueCount()).append("\n");
        return stringBuilder.toString();
    }
}

