/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.db;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.limewire.mojito.db.DHTValue;
import org.limewire.mojito.db.DHTValueFactory;
import org.limewire.mojito.db.DHTValueType;
import org.limewire.mojito.db.impl.DefaultDHTValueFactory;
import org.limewire.mojito.exceptions.DHTValueException;
import org.limewire.mojito.routing.Version;

public class DHTValueFactoryManager {
    public static final DHTValueFactory defaultFactory = new DefaultDHTValueFactory();
    private final Map<DHTValueType, DHTValueFactory> factories = Collections.synchronizedMap(new HashMap());

    public DHTValueFactory addValueFactory(DHTValueType dHTValueType, DHTValueFactory dHTValueFactory) {
        if (dHTValueType == null) {
            throw new NullPointerException("DHTValueType is null");
        }
        if (dHTValueFactory == null) {
            throw new NullPointerException("DHTValueFactory is null");
        }
        return this.factories.put(dHTValueType, dHTValueFactory);
    }

    public DHTValueFactory removeValueFactory(DHTValueType dHTValueType) {
        if (dHTValueType == null) {
            throw new NullPointerException("DHTValueType is null");
        }
        return this.factories.remove(dHTValueType);
    }

    public DHTValueFactory getValueFactory(DHTValueType dHTValueType) {
        if (dHTValueType == null) {
            throw new NullPointerException("DHTValueType is null");
        }
        DHTValueFactory dHTValueFactory = this.factories.get(dHTValueType);
        if (dHTValueFactory != null) {
            return dHTValueFactory;
        }
        return defaultFactory;
    }

    public DHTValue createDHTValue(DHTValueType dHTValueType, Version version, byte[] byArray) throws DHTValueException {
        if (dHTValueType == null) {
            throw new NullPointerException("DHTValueType is null");
        }
        if (version == null) {
            throw new NullPointerException("Version is null");
        }
        if (byArray == null || byArray.length == 0) {
            return defaultFactory.createDHTValue(dHTValueType, version, byArray);
        }
        return this.getValueFactory(dHTValueType).createDHTValue(dHTValueType, version, byArray);
    }
}

