/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.db;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import org.limewire.mojito.db.DHTValueType;
import org.limewire.mojito.routing.Version;

public interface DHTValue
extends Serializable {
    public static final DHTValue EMPTY_VALUE = new EmptyValue();

    public DHTValueType getValueType();

    public Version getVersion();

    public byte[] getValue();

    public void write(OutputStream var1) throws IOException;

    public int size();

    public static final class EmptyValue
    implements DHTValue {
        private static final long serialVersionUID = 4690500560328936523L;
        private static final byte[] EMPTY = new byte[0];

        private EmptyValue() {
        }

        public byte[] getValue() {
            return EMPTY;
        }

        public void write(OutputStream outputStream) throws IOException {
        }

        public DHTValueType getValueType() {
            return DHTValueType.BINARY;
        }

        public Version getVersion() {
            return Version.ZERO;
        }

        public int size() {
            return 0;
        }

        public String toString() {
            return "This is an empty DHTValue";
        }
    }
}

