/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.concurrent;

import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.mojito.concurrent.Cancellable;
import org.limewire.mojito.concurrent.DHTExecutorService;
import org.limewire.mojito.concurrent.DefaultThreadFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDHTExecutorService
implements DHTExecutorService {
    private volatile ThreadFactory threadFactory;
    private ScheduledExecutorService scheduledExecutor;
    private ExecutorService cachedExecutor;
    private ExecutorService sequentialExecutor;
    private final String name;
    private volatile boolean running = false;

    public DefaultDHTExecutorService(String string) {
        this.name = string;
        this.threadFactory = new DefaultThreadFactory(string);
    }

    @Override
    public void start() {
        if (!this.running) {
            this.initScheduledExecutor();
            this.initCachedExecutor();
            this.initSequantialExecutor();
            this.running = true;
        }
    }

    @Override
    public void stop() {
        if (this.running) {
            this.running = false;
            this.cancel(this.scheduledExecutor.shutdownNow());
            this.cancel(this.cachedExecutor.shutdownNow());
            this.cancel(this.sequentialExecutor.shutdownNow());
        }
    }

    private void cancel(Collection<?> collection) {
        for (Object obj : collection) {
            if (!(obj instanceof Cancellable)) continue;
            ((Cancellable)obj).cancel(true);
        }
    }

    private void initScheduledExecutor() {
        ThreadFactory threadFactory = new ThreadFactory(){

            public Thread newThread(Runnable runnable) {
                Thread thread = DefaultDHTExecutorService.this.getThreadFactory().newThread(runnable);
                thread.setName(DefaultDHTExecutorService.this.name + "-ContextScheduledThreadPool");
                thread.setDaemon(true);
                return thread;
            }
        };
        this.scheduledExecutor = Executors.newScheduledThreadPool(1, threadFactory);
    }

    private void initCachedExecutor() {
        ThreadFactory threadFactory = new ThreadFactory(){

            public Thread newThread(Runnable runnable) {
                Thread thread = DefaultDHTExecutorService.this.getThreadFactory().newThread(runnable);
                thread.setName(DefaultDHTExecutorService.this.name + "-ContextCachedThreadPool");
                thread.setDaemon(true);
                return thread;
            }
        };
        this.cachedExecutor = ExecutorsHelper.newThreadPool(threadFactory);
    }

    private void initSequantialExecutor() {
        this.sequentialExecutor = ExecutorsHelper.newProcessingQueue("DHT-Sequential-Executor");
    }

    @Override
    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    @Override
    public void setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable runnable, long l, long l2, TimeUnit timeUnit) {
        return this.scheduledExecutor.scheduleAtFixedRate(runnable, l, l2, timeUnit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable runnable, long l, long l2, TimeUnit timeUnit) {
        return this.scheduledExecutor.scheduleWithFixedDelay(runnable, l, l2, timeUnit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long l, TimeUnit timeUnit) {
        return this.scheduledExecutor.schedule(callable, l, timeUnit);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable runnable, long l, TimeUnit timeUnit) {
        return this.scheduledExecutor.schedule(runnable, l, timeUnit);
    }

    @Override
    public <V> Future<V> submit(Callable<V> callable) {
        return this.cachedExecutor.submit(callable);
    }

    @Override
    public void execute(Runnable runnable) {
        if (this.running) {
            this.cachedExecutor.execute(runnable);
        }
    }

    @Override
    public void executeSequentially(Runnable runnable) {
        if (this.running) {
            this.sequentialExecutor.execute(runnable);
        }
    }
}

