/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.listener;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.limewire.listener.EventListener;
import org.limewire.listener.ListenerSupport;
import org.limewire.util.Objects;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventListenerList<E>
implements ListenerSupport<E> {
    private final List<EventListener<E>> listenerList = new CopyOnWriteArrayList<EventListener<E>>();

    @Override
    public void addListener(EventListener<E> eventListener) {
        this.listenerList.add(Objects.nonNull(eventListener, "listener"));
    }

    @Override
    public boolean removeListener(EventListener<E> eventListener) {
        return this.listenerList.remove(Objects.nonNull(eventListener, "listener"));
    }

    public void broadcast(E e) {
        Objects.nonNull(e, "event");
        for (EventListener<E> eventListener : this.listenerList) {
            eventListener.handleEvent(e);
        }
    }
}

