/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.lifecycle;

import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.limewire.lifecycle.Service;
import org.limewire.lifecycle.ServiceRegistry;
import org.limewire.lifecycle.ServiceStage;
import org.limewire.lifecycle.StagedRegisterBuilder;
import org.limewire.lifecycle.StagedRegisterBuilderImpl;

@Singleton
class ServiceRegistryImpl
implements ServiceRegistry {
    private final List<StagedRegisterBuilderImpl> builders = new ArrayList<StagedRegisterBuilderImpl>();
    private final Map<Object, List<ServiceHolder>> services = new HashMap<Object, List<ServiceHolder>>();
    private final List<ServiceHolder> startedServices = new ArrayList<ServiceHolder>();

    ServiceRegistryImpl() {
    }

    /*
     * WARNING - void declaration
     */
    public void initialize() {
        ServiceStage[] serviceStageArray = this.builders.iterator();
        while (serviceStageArray.hasNext()) {
            void object;
            List<ServiceHolder> list;
            StagedRegisterBuilderImpl stagedRegisterBuilderImpl = serviceStageArray.next();
            Object object2 = stagedRegisterBuilderImpl.getCustomStage();
            if (object2 == null) {
                object2 = stagedRegisterBuilderImpl.getStage();
            }
            if ((list = this.services.get(object2)) == null) {
                ArrayList arrayList = new ArrayList();
                this.services.put(object2, arrayList);
            }
            object.add(new ServiceHolder(stagedRegisterBuilderImpl.getService()));
            serviceStageArray.remove();
        }
        for (ServiceStage serviceStage : this.getStagesInOrder()) {
            if (this.services.get((Object)serviceStage) == null) continue;
            for (ServiceHolder serviceHolder : this.services.get((Object)serviceStage)) {
                serviceHolder.init();
            }
        }
        for (Map.Entry entry : this.services.entrySet()) {
            if (entry.getKey().getClass() == ServiceStage.class || entry.getValue() == null) continue;
            for (ServiceHolder serviceHolder : (List)entry.getValue()) {
                serviceHolder.init();
            }
        }
    }

    public void start(Object object) {
        this.initialize();
        this.startStage(object);
    }

    public void start() {
        this.initialize();
        for (ServiceStage serviceStage : this.getStagesInOrder()) {
            this.startStage((Object)serviceStage);
        }
    }

    private void startStage(Object object) {
        List<ServiceHolder> list = this.services.get(object);
        if (list != null) {
            Iterator<ServiceHolder> iterator = list.iterator();
            while (iterator.hasNext()) {
                ServiceHolder serviceHolder = iterator.next();
                serviceHolder.start();
                this.startedServices.add(serviceHolder);
                iterator.remove();
            }
        }
    }

    public void stop() {
        for (int i = this.startedServices.size() - 1; i >= 0; --i) {
            this.startedServices.get(i).stop();
            this.startedServices.remove(i);
        }
    }

    public StagedRegisterBuilder register(Service service) {
        StagedRegisterBuilderImpl stagedRegisterBuilderImpl = new StagedRegisterBuilderImpl(service);
        this.builders.add(stagedRegisterBuilderImpl);
        return stagedRegisterBuilderImpl;
    }

    ServiceStage[] getStagesInOrder() {
        return new ServiceStage[]{ServiceStage.EARLY, ServiceStage.NORMAL, ServiceStage.LATE};
    }

    private static class ServiceHolder {
        private final Service service;
        private boolean initted;
        private boolean started;
        private boolean stopped;

        public ServiceHolder(Service service) {
            this.service = service;
        }

        void init() {
            if (!this.initted) {
                this.initted = true;
                this.service.initialize();
            }
        }

        void start() {
            if (!this.started) {
                this.started = true;
                this.service.start();
            }
        }

        void stop() {
            if (!this.stopped) {
                this.stopped = true;
                this.service.stop();
            }
        }
    }
}

