/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.io;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import org.limewire.io.IpPort;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.io.NetworkUtils;

@Singleton
public class SimpleNetworkInstanceUtils
implements NetworkInstanceUtils {
    private final boolean localIsPrivate;

    @Inject
    public SimpleNetworkInstanceUtils() {
        this(true);
    }

    public SimpleNetworkInstanceUtils(boolean bl) {
        this.localIsPrivate = bl;
    }

    public boolean isMe(byte[] byArray, int n) {
        return false;
    }

    public boolean isMe(IpPort ipPort) {
        return false;
    }

    public boolean isMe(String string, int n) {
        return false;
    }

    public boolean isPrivate() {
        return false;
    }

    public boolean isPrivateAddress(byte[] byArray) {
        return this.localIsPrivate && NetworkUtils.isPrivateAddress(byArray);
    }

    public boolean isPrivateAddress(InetAddress inetAddress) {
        return this.localIsPrivate && NetworkUtils.isPrivateAddress(inetAddress);
    }

    public boolean isPrivateAddress(SocketAddress socketAddress) {
        return this.localIsPrivate && NetworkUtils.isPrivateAddress(((InetSocketAddress)socketAddress).getAddress());
    }

    public boolean isPrivateAddress(String string) {
        try {
            return this.localIsPrivate && NetworkUtils.isPrivateAddress(InetAddress.getByName(string));
        }
        catch (UnknownHostException unknownHostException) {
            return true;
        }
    }

    public boolean isValidExternalIpPort(IpPort ipPort) {
        return NetworkUtils.isValidExternalIpPort(ipPort);
    }

    public boolean isVeryCloseIP(byte[] byArray) {
        return false;
    }

    public boolean isVeryCloseIP(byte[] byArray, byte[] byArray2) {
        return NetworkUtils.isVeryCloseIP(byArray, byArray2);
    }

    public boolean isVeryCloseIP(InetAddress inetAddress) {
        return false;
    }
}

