/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.io;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import org.limewire.io.Connectable;
import org.limewire.io.ConnectableImpl;
import org.limewire.io.IP;
import org.limewire.io.InvalidDataException;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortImpl;
import org.limewire.util.ByteUtils;
import org.limewire.util.Decorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NetworkUtils {
    public static final int CLASS_C_NETMASK = -256;

    private NetworkUtils() {
    }

    public static boolean isValidAddressAndPort(byte[] byArray, int n) {
        return NetworkUtils.isValidAddress(byArray) && NetworkUtils.isValidPort(n);
    }

    public static boolean isValidAddressAndPort(String string, int n) {
        return NetworkUtils.isValidAddress(string) && NetworkUtils.isValidPort(n);
    }

    public static boolean isValidIpPort(IpPort ipPort) {
        return NetworkUtils.isValidAddress(ipPort.getAddress()) && NetworkUtils.isValidPort(ipPort.getPort());
    }

    public static boolean isValidPort(int n) {
        return n > 0 && n <= 65535;
    }

    public static boolean isValidAddress(byte[] byArray) {
        return !NetworkUtils.isAnyLocalAddress(byArray) && !NetworkUtils.isInvalidAddress(byArray) && !NetworkUtils.isBroadcastAddress(byArray) && !NetworkUtils.isDocumentationAddress(byArray);
    }

    public static boolean isValidAddress(IP iP) {
        int n = iP.addr >> 24 & 0xFF;
        return n != 0 && n != 255;
    }

    public static boolean isValidAddress(InetAddress inetAddress) {
        return !inetAddress.isAnyLocalAddress() && !NetworkUtils.isInvalidAddress(inetAddress) && !NetworkUtils.isBroadcastAddress(inetAddress) && !NetworkUtils.isDocumentationAddress(inetAddress);
    }

    public static boolean isValidAddress(String string) {
        try {
            return NetworkUtils.isValidAddress(InetAddress.getByName(string));
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
    }

    public static boolean isDottedIPV4(String string) {
        int n;
        int n2 = 0;
        while (n2 < 3) {
            n = string.indexOf(".");
            if (n == -1) {
                return false;
            }
            String string2 = string.substring(0, n);
            try {
                int n3 = Integer.parseInt(string2);
                if (n3 < 0 || n3 > 255) {
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            ++n2;
            string = string.substring(Math.min(n + 1, string.length()), string.length());
        }
        if (string.indexOf(".") != -1) {
            return false;
        }
        try {
            n = Integer.parseInt(string);
            if (n < 0 || n > 255) {
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public static boolean isAddress(String string) {
        int n = (string = string.trim()).indexOf(":");
        if (n == -1) {
            return string.length() > 0;
        }
        if (n > 0) {
            try {
                int n2 = Integer.parseInt(string.substring(n + 1));
                return NetworkUtils.isValidPort(n2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    static boolean isValidExternalIpPort(IpPort ipPort) {
        InetAddress inetAddress = ipPort.getInetAddress();
        return inetAddress != null && NetworkUtils.isValidAddress(inetAddress) && NetworkUtils.isValidPort(ipPort.getPort());
    }

    public static boolean isValidSocketAddress(SocketAddress socketAddress) {
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        return !inetSocketAddress.isUnresolved() && NetworkUtils.isValidAddress(inetSocketAddress.getAddress()) && NetworkUtils.isValidPort(inetSocketAddress.getPort());
    }

    public static boolean isLocalAddress(InetAddress inetAddress) {
        if (inetAddress.isAnyLocalAddress() || inetAddress.isLoopbackAddress()) {
            return true;
        }
        try {
            return NetworkInterface.getByInetAddress(inetAddress) != null;
        }
        catch (SocketException socketException) {
            return false;
        }
    }

    public static boolean isLocalAddress(SocketAddress socketAddress) {
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        return !inetSocketAddress.isUnresolved() && NetworkUtils.isLocalAddress(inetSocketAddress.getAddress());
    }

    public static boolean isCloseIP(InetAddress inetAddress, InetAddress inetAddress2) {
        return NetworkUtils.isCloseIP(inetAddress.getAddress(), inetAddress2.getAddress());
    }

    public static boolean isCloseIP(byte[] byArray, byte[] byArray2) {
        if (NetworkUtils.isIPv4Address(byArray) && NetworkUtils.isIPv4Address(byArray2) || NetworkUtils.isIPv4MappedAddress(byArray) && NetworkUtils.isIPv4MappedAddress(byArray2)) {
            return byArray[byArray.length - 4] == byArray2[byArray2.length - 4];
        }
        return false;
    }

    public static boolean isVeryCloseIP(byte[] byArray, byte[] byArray2) {
        if (NetworkUtils.isIPv4Address(byArray) && NetworkUtils.isIPv4Address(byArray2) || NetworkUtils.isIPv4MappedAddress(byArray) && NetworkUtils.isIPv4MappedAddress(byArray2)) {
            return byArray[byArray.length - 4] == byArray2[byArray2.length - 4] && byArray[byArray.length - 3] == byArray2[byArray2.length - 3];
        }
        return false;
    }

    static boolean isPrivateAddress(InetAddress inetAddress) {
        return inetAddress.isAnyLocalAddress() || inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress() || inetAddress.isSiteLocalAddress() || NetworkUtils.isUniqueLocalUnicastAddress(inetAddress) || NetworkUtils.isBroadcastAddress(inetAddress) || NetworkUtils.isInvalidAddress(inetAddress) || NetworkUtils.isDocumentationAddress(inetAddress);
    }

    static boolean isPrivateAddress(byte[] byArray) {
        return NetworkUtils.isAnyLocalAddress(byArray) || NetworkUtils.isInvalidAddress(byArray) || NetworkUtils.isLoopbackAddress(byArray) || NetworkUtils.isLinkLocalAddress(byArray) || NetworkUtils.isSiteLocalAddress(byArray) || NetworkUtils.isUniqueLocalUnicastAddress(byArray) || NetworkUtils.isBroadcastAddress(byArray) || NetworkUtils.isDocumentationAddress(byArray);
    }

    public static final String ip2string(byte[] byArray) {
        return NetworkUtils.ip2string(byArray, 0);
    }

    public static final String ip2string(byte[] byArray, int n) {
        StringBuilder stringBuilder = new StringBuilder(16);
        stringBuilder.append(ByteUtils.ubyte2int(byArray[n]));
        stringBuilder.append('.');
        stringBuilder.append(ByteUtils.ubyte2int(byArray[n + 1]));
        stringBuilder.append('.');
        stringBuilder.append(ByteUtils.ubyte2int(byArray[n + 2]));
        stringBuilder.append('.');
        stringBuilder.append(ByteUtils.ubyte2int(byArray[n + 3]));
        return stringBuilder.toString();
    }

    public static boolean isLocalHost(Socket socket) {
        return NetworkUtils.isLocalAddress(socket.getInetAddress());
    }

    public static byte[] packIpPorts(Collection<? extends IpPort> collection) {
        byte[] byArray = new byte[collection.size() * 6];
        int n = 0;
        for (IpPort ipPort : collection) {
            byte[] byArray2 = ipPort.getInetAddress().getAddress();
            int n2 = ipPort.getPort();
            System.arraycopy(byArray2, 0, byArray, n, 4);
            ByteUtils.short2leb((short)n2, byArray, n += 4);
            n += 2;
        }
        return byArray;
    }

    public static List<IpPort> unpackIps(byte[] byArray) throws InvalidDataException {
        return NetworkUtils.unpackIps(byArray, null);
    }

    public static List<IpPort> unpackIps(byte[] byArray, Decorator<IpPort, ? extends IpPort> decorator) throws InvalidDataException {
        if (byArray.length % 6 != 0) {
            throw new InvalidDataException("invalid size");
        }
        int n = byArray.length / 6;
        ArrayList<IpPort> arrayList = new ArrayList<IpPort>(n);
        byte[] byArray2 = new byte[6];
        for (int i = 0; i < n; ++i) {
            System.arraycopy(byArray, i * 6, byArray2, 0, 6);
            IpPort ipPort = NetworkUtils.getIpPort(byArray2, ByteOrder.LITTLE_ENDIAN);
            if (decorator != null && (ipPort = decorator.decorate(ipPort)) == null) {
                throw new InvalidDataException("decorator returned null");
            }
            arrayList.add(ipPort);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public static <T extends IpPort> Collection<T> filterOnePerClassC(Collection<T> collection) {
        return NetworkUtils.filterUnique(collection, -256);
    }

    public static <T extends IpPort> Collection<T> filterUnique(Collection<T> collection, int n) {
        ArrayList<IpPort> arrayList = new ArrayList<IpPort>(collection.size());
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (IpPort ipPort : collection) {
            if (!hashSet.add(NetworkUtils.getMaskedIP(ipPort.getInetAddress(), n))) continue;
            arrayList.add(ipPort);
        }
        arrayList.trimToSize();
        return arrayList;
    }

    public static int getClassC(InetAddress inetAddress) {
        return NetworkUtils.getMaskedIP(inetAddress, -256);
    }

    public static int getMaskedIP(InetAddress inetAddress, int n) {
        byte[] byArray = inetAddress.getAddress();
        return ByteUtils.beb2int(byArray, byArray.length - 4) & n;
    }

    public static byte[] toByteAddress(int n) {
        byte[] byArray = new byte[4];
        ByteUtils.int2beb(n, byArray, 0);
        return byArray;
    }

    public static int getHexMask(int n) {
        if (n < 0 || n > 32) {
            throw new IllegalArgumentException("bad mask " + n);
        }
        if (n == 0) {
            return 0;
        }
        return -1 << 32 - n;
    }

    public static InetAddress getLocalAddress() throws UnknownHostException {
        InetAddress inetAddress = InetAddress.getLocalHost();
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    Enumeration<InetAddress> enumeration2 = enumeration.nextElement().getInetAddresses();
                    while (enumeration2.hasMoreElements()) {
                        inetAddress = enumeration2.nextElement();
                        if (!(inetAddress instanceof Inet4Address) || inetAddress.isLoopbackAddress()) continue;
                        return inetAddress;
                    }
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        throw new UnknownHostException("localhost has no interface with a non-loopback IPv4 address");
    }

    public static byte[] getBytes(SocketAddress socketAddress, ByteOrder byteOrder) throws UnknownHostException {
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        if (inetSocketAddress.isUnresolved()) {
            throw new UnknownHostException(inetSocketAddress.toString());
        }
        return NetworkUtils.getBytes(inetSocketAddress.getAddress(), inetSocketAddress.getPort(), byteOrder);
    }

    public static byte[] getBytes(IpPort ipPort, ByteOrder byteOrder) {
        return NetworkUtils.getBytes(ipPort.getInetAddress(), ipPort.getPort(), byteOrder);
    }

    public static byte[] getBytes(InetAddress inetAddress, int n, ByteOrder byteOrder) {
        if (!NetworkUtils.isValidPort(n)) {
            throw new IllegalArgumentException("Port out of range: " + n);
        }
        if (!NetworkUtils.isValidAddress(inetAddress)) {
            throw new IllegalArgumentException("invalid addr: " + inetAddress);
        }
        byte[] byArray = inetAddress.getAddress();
        byte[] byArray2 = new byte[byArray.length + 2];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            ByteUtils.short2beb((short)n, byArray2, byArray2.length - 2);
        } else {
            ByteUtils.short2leb((short)n, byArray2, byArray2.length - 2);
        }
        return byArray2;
    }

    public static IpPort getIpPort(byte[] byArray, ByteOrder byteOrder) throws InvalidDataException {
        InetAddress inetAddress;
        if (byArray.length < 6) {
            throw new InvalidDataException("length must be >= 6, is: " + byArray.length);
        }
        short s = byteOrder == ByteOrder.BIG_ENDIAN ? ByteUtils.beb2short(byArray, byArray.length - 2) : ByteUtils.leb2short(byArray, byArray.length - 2);
        int n = ByteUtils.ushort2int(s);
        if (!NetworkUtils.isValidPort(n)) {
            throw new InvalidDataException("Bad Port: " + n);
        }
        try {
            byte[] byArray2 = new byte[byArray.length - 2];
            System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
            inetAddress = InetAddress.getByAddress(byArray2);
        }
        catch (UnknownHostException unknownHostException) {
            throw new InvalidDataException("bad host.");
        }
        if (!NetworkUtils.isValidAddress(inetAddress)) {
            throw new InvalidDataException("invalid addr: " + inetAddress);
        }
        return new IpPortImpl(new InetSocketAddress(inetAddress, n));
    }

    public static boolean isSameAddressSpace(SocketAddress socketAddress, SocketAddress socketAddress2) {
        return NetworkUtils.isSameAddressSpace(((InetSocketAddress)socketAddress).getAddress(), ((InetSocketAddress)socketAddress2).getAddress());
    }

    public static boolean isSameAddressSpace(InetAddress inetAddress, InetAddress inetAddress2) {
        if (inetAddress == null || inetAddress2 == null) {
            return false;
        }
        return inetAddress instanceof Inet4Address && inetAddress2 instanceof Inet4Address || inetAddress instanceof Inet6Address && inetAddress2 instanceof Inet6Address;
    }

    public static byte[] getIPv6AddressBytes(InetAddress inetAddress) {
        byte[] byArray = inetAddress.getAddress();
        switch (byArray.length) {
            case 16: {
                return byArray;
            }
            case 4: {
                byte[] byArray2 = new byte[16];
                byArray2[10] = -1;
                byArray2[11] = -1;
                System.arraycopy(byArray, 0, byArray2, 12, byArray.length);
                return byArray2;
            }
        }
        throw new IllegalArgumentException("unhandled address length");
    }

    public static boolean isIPv6Compatible(InetAddress inetAddress) {
        int n = inetAddress.getAddress().length;
        return n == 4 || n == 16;
    }

    private static boolean isIPv4Address(byte[] byArray) {
        return byArray.length == 4;
    }

    static boolean isIPv4CompatibleAddress(byte[] byArray) {
        return byArray.length == 16 && byArray[0] == 0 && byArray[1] == 0 && byArray[2] == 0 && byArray[3] == 0 && byArray[4] == 0 && byArray[5] == 0 && byArray[6] == 0 && byArray[7] == 0 && byArray[8] == 0 && byArray[9] == 0 && byArray[10] == 0 && byArray[11] == 0;
    }

    static boolean isIPv4MappedAddress(byte[] byArray) {
        return byArray.length == 16 && byArray[0] == 0 && byArray[1] == 0 && byArray[2] == 0 && byArray[3] == 0 && byArray[4] == 0 && byArray[5] == 0 && byArray[6] == 0 && byArray[7] == 0 && byArray[8] == 0 && byArray[9] == 0 && byArray[10] == -1 && byArray[11] == -1;
    }

    private static boolean isInvalidAddress(InetAddress inetAddress) {
        return NetworkUtils.isInvalidAddress(inetAddress.getAddress());
    }

    private static boolean isInvalidAddress(byte[] byArray) {
        if (NetworkUtils.isIPv4Address(byArray) || NetworkUtils.isIPv4MappedAddress(byArray)) {
            return byArray[byArray.length - 4] == 0;
        }
        return false;
    }

    static boolean isAnyLocalAddress(byte[] byArray) {
        if (byArray.length == 4 || byArray.length == 16) {
            byte by = 0;
            for (int i = 0; i < byArray.length; ++i) {
                by = (byte)(by | byArray[i]);
            }
            return by == 0;
        }
        return false;
    }

    static boolean isLoopbackAddress(byte[] byArray) {
        if (NetworkUtils.isIPv4Address(byArray) || NetworkUtils.isIPv4MappedAddress(byArray)) {
            return (byArray[byArray.length - 4] & 0xFF) == 127;
        }
        if (byArray.length == 16) {
            byte by = 0;
            for (int i = 0; i < 15; ++i) {
                by = (byte)(by | byArray[i]);
            }
            return by == 0 && byArray[15] == 1;
        }
        return false;
    }

    static boolean isLinkLocalAddress(byte[] byArray) {
        if (NetworkUtils.isIPv4Address(byArray) || NetworkUtils.isIPv4MappedAddress(byArray)) {
            return (byArray[byArray.length - 4] & 0xFF) == 169 && (byArray[byArray.length - 3] & 0xFF) == 254;
        }
        if (byArray.length == 16) {
            return (byArray[0] & 0xFF) == 254 && (byArray[1] & 0xC0) == 128;
        }
        return false;
    }

    static boolean isSiteLocalAddress(byte[] byArray) {
        if (NetworkUtils.isIPv4Address(byArray) || NetworkUtils.isIPv4MappedAddress(byArray)) {
            return (byArray[byArray.length - 4] & 0xFF) == 10 || (byArray[byArray.length - 4] & 0xFF) == 172 && (byArray[byArray.length - 3] & 0xF0) == 16 || (byArray[byArray.length - 4] & 0xFF) == 192 && (byArray[byArray.length - 3] & 0xFF) == 168;
        }
        if (byArray.length == 16) {
            return (byArray[0] & 0xFF) == 254 && (byArray[1] & 0xC0) == 192;
        }
        return false;
    }

    public static boolean isUniqueLocalUnicastAddress(InetAddress inetAddress) {
        if (inetAddress instanceof Inet6Address) {
            return NetworkUtils.isUniqueLocalUnicastAddress(inetAddress.getAddress());
        }
        return false;
    }

    private static boolean isUniqueLocalUnicastAddress(byte[] byArray) {
        if (byArray.length == 16) {
            return (byArray[0] & 0xFE) == 252;
        }
        return false;
    }

    public static boolean isBroadcastAddress(InetAddress inetAddress) {
        return NetworkUtils.isBroadcastAddress(inetAddress.getAddress());
    }

    private static boolean isBroadcastAddress(byte[] byArray) {
        if (NetworkUtils.isIPv4Address(byArray) || NetworkUtils.isIPv4MappedAddress(byArray)) {
            return (byArray[byArray.length - 4] & 0xFF) == 255;
        }
        return false;
    }

    public static boolean isPrivateIPv4CompatibleAddress(InetAddress inetAddress) {
        if (inetAddress instanceof Inet6Address) {
            return NetworkUtils.isPrivateIPv4CompatibleAddress(inetAddress.getAddress());
        }
        return false;
    }

    private static boolean isPrivateIPv4CompatibleAddress(byte[] byArray) {
        if (NetworkUtils.isIPv4CompatibleAddress(byArray)) {
            byte[] byArray2 = new byte[4];
            System.arraycopy(byArray, 12, byArray2, 0, byArray2.length);
            return NetworkUtils.isPrivateAddress(byArray2);
        }
        return false;
    }

    public static boolean isDocumentationAddress(InetAddress inetAddress) {
        if (inetAddress instanceof Inet6Address) {
            return NetworkUtils.isDocumentationAddress(inetAddress.getAddress());
        }
        return false;
    }

    private static boolean isDocumentationAddress(byte[] byArray) {
        if (byArray.length == 16) {
            return (byArray[0] & 0xFF) == 32 && (byArray[1] & 0xFF) == 1 && (byArray[2] & 0xFF) == 13 && (byArray[3] & 0xFF) == 184;
        }
        return false;
    }

    static int parsePort(String string) throws IOException {
        try {
            int n = Integer.parseInt(string);
            if (!NetworkUtils.isValidPort(n)) {
                throw new IOException("invalid port: " + n);
            }
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            throw (IOException)new IOException().initCause(numberFormatException);
        }
    }

    static InetAddress getAndCheckAddress(String string) throws IOException {
        InetAddress inetAddress = InetAddress.getByName(string);
        if (!NetworkUtils.isValidAddress(inetAddress)) {
            throw new IOException("invalid addr: " + inetAddress);
        }
        return inetAddress;
    }

    static int getAndCheckIpPortSeparator(String string) throws IOException {
        int n = string.indexOf(":");
        if (n <= 0 || n != string.lastIndexOf(":") || n == string.length() - 1) {
            throw new IOException("invalid separator in http: " + string);
        }
        return n;
    }

    public static Connectable parseIpPort(String string, boolean bl) throws IOException {
        int n = NetworkUtils.getAndCheckIpPortSeparator(string);
        InetAddress inetAddress = NetworkUtils.getAndCheckAddress(string.substring(0, n));
        int n2 = NetworkUtils.parsePort(string.substring(n + 1));
        return new ConnectableImpl(new InetSocketAddress(inetAddress, n2), bl);
    }

    public static IpPort parsePortIp(String string) throws IOException {
        int n = NetworkUtils.getAndCheckIpPortSeparator(string);
        int n2 = NetworkUtils.parsePort(string.substring(0, n));
        InetAddress inetAddress = NetworkUtils.getAndCheckAddress(string.substring(n + 1));
        return new IpPortImpl(inetAddress, n2);
    }
}

