/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.io;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortForSelf;
import org.limewire.io.LocalSocketAddressProvider;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.io.NetworkUtils;

@Singleton
class NetworkInstanceUtilsImpl
implements NetworkInstanceUtils {
    private final LocalSocketAddressProvider localSocketAddressProvider;
    private final IpPortForSelf ipPortForSelf;

    @Inject
    NetworkInstanceUtilsImpl(LocalSocketAddressProvider localSocketAddressProvider, IpPortForSelf ipPortForSelf) {
        this.localSocketAddressProvider = localSocketAddressProvider;
        this.ipPortForSelf = ipPortForSelf;
    }

    public boolean isMe(String string, int n) {
        try {
            return this.isMe(InetAddress.getByName(string).getAddress(), n);
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
    }

    public boolean isMe(byte[] byArray, int n) {
        if (NetworkUtils.isLoopbackAddress(byArray)) {
            return n == this.localSocketAddressProvider.getLocalPort();
        }
        byte[] byArray2 = this.localSocketAddressProvider.getLocalAddress();
        return n == this.localSocketAddressProvider.getLocalPort() && Arrays.equals(byArray, byArray2);
    }

    public boolean isMe(IpPort ipPort) {
        if (ipPort == this.ipPortForSelf) {
            return true;
        }
        return this.isMe(ipPort.getInetAddress().getAddress(), ipPort.getPort());
    }

    public boolean isVeryCloseIP(byte[] byArray, byte[] byArray2) {
        if (!this.isPrivateAddress(byArray)) {
            return false;
        }
        return NetworkUtils.isVeryCloseIP(byArray, byArray2);
    }

    public boolean isVeryCloseIP(InetAddress inetAddress) {
        return this.isVeryCloseIP(inetAddress.getAddress());
    }

    public boolean isVeryCloseIP(byte[] byArray) {
        return this.isVeryCloseIP(this.localSocketAddressProvider.getLocalAddress(), byArray);
    }

    public boolean isPrivate() {
        return this.isPrivateAddress(this.localSocketAddressProvider.getLocalAddress());
    }

    public boolean isPrivateAddress(InetAddress inetAddress) {
        if (!this.localSocketAddressProvider.isLocalAddressPrivate()) {
            return false;
        }
        return NetworkUtils.isPrivateAddress(inetAddress);
    }

    public boolean isPrivateAddress(byte[] byArray) {
        if (!this.localSocketAddressProvider.isLocalAddressPrivate()) {
            return false;
        }
        return NetworkUtils.isPrivateAddress(byArray);
    }

    public boolean isPrivateAddress(String string) {
        try {
            return this.isPrivateAddress(InetAddress.getByName(string));
        }
        catch (UnknownHostException unknownHostException) {
            return true;
        }
    }

    public boolean isPrivateAddress(SocketAddress socketAddress) {
        return this.isPrivateAddress(((InetSocketAddress)socketAddress).getAddress());
    }

    public boolean isValidExternalIpPort(IpPort ipPort) {
        return NetworkUtils.isValidExternalIpPort(ipPort) && !this.isPrivateAddress(ipPort.getInetAddress());
    }
}

