/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.EnumMap;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.limewire.i18n.I18nMarker;
import org.limewire.service.ErrorService;
import org.limewire.service.MessageService;
import org.limewire.util.FileUtils;
import org.limewire.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IOUtils {
    private static final EnumMap<ErrorType, EnumMap<DetailErrorType, String>> errorDescs = new EnumMap(ErrorType.class);

    public static boolean handleException(IOException iOException, ErrorType errorType) {
        for (Throwable throwable = iOException; throwable != null; throwable = throwable.getCause()) {
            String string = throwable.getMessage();
            if (string == null) continue;
            string = string.toLowerCase();
            DetailErrorType detailErrorType = null;
            if (StringUtils.contains(string, "no space left") || StringUtils.contains(string, "not enough space")) {
                detailErrorType = DetailErrorType.DISK_FULL;
            } else if (StringUtils.contains(string, "being used by another process") || StringUtils.contains(string, "with a user-mapped section open")) {
                detailErrorType = DetailErrorType.FILE_LOCKED;
            } else if (StringUtils.contains(string, "access is denied") || StringUtils.contains(string, "permission denied")) {
                detailErrorType = DetailErrorType.NO_PRIVS;
            } else if (StringUtils.contains(string, "invalid argument")) {
                detailErrorType = DetailErrorType.BAD_CHARS;
            }
            if (detailErrorType == null) continue;
            MessageService.showError(errorDescs.get((Object)errorType).get((Object)detailErrorType));
            return true;
        }
        return false;
    }

    public static IOException getIOException(String string, Throwable throwable) {
        IOException iOException = new IOException(string);
        iOException.initCause(throwable);
        return iOException;
    }

    public static String readWord(InputStream inputStream, int n) throws IOException {
        char[] cArray = new char[n];
        int n2 = 0;
        try {
            int n3;
            while ((n3 = inputStream.read()) >= 0) {
                if ((char)n3 != ' ') {
                    if (n2 < n) {
                        cArray[n2++] = (char)n3;
                        continue;
                    }
                    throw new IOException("could not read word");
                }
                return new String(cArray, 0, n2);
            }
            throw new IOException("unexpected end of file");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IOException("unexpected aioobe");
        }
    }

    public static String readLargestWord(InputStream inputStream, int n) throws IOException {
        char[] cArray = new char[n];
        int n2 = 0;
        try {
            block5: {
                block6: {
                    while (true) {
                        int n3;
                        if ((n3 = inputStream.read()) == -1) {
                            if (n2 == 0) {
                                throw new IOException("could not read any word.");
                            }
                            return new String(cArray, 0, n2);
                        }
                        if (n3 < 0) break block5;
                        if ((char)n3 == ' ') break block6;
                        if (n2 >= n) break;
                        cArray[n2++] = (char)n3;
                    }
                    throw new IOException("could not read word");
                }
                return new String(cArray, 0, n2);
            }
            throw new IOException("unknown got amount");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IOException("unexpected aioobe");
        }
    }

    public static long ensureSkip(InputStream inputStream, long l) throws IOException {
        long l2;
        long l3;
        for (l2 = 0L; l2 < l; l2 += l3) {
            l3 = inputStream.skip(l - l2);
            if (l3 != -1L && l3 != 0L) continue;
            throw new EOFException("eof");
        }
        return l2;
    }

    public static void close(Closeable closeable) {
        FileUtils.close(closeable);
    }

    public static void close(Iterable<? extends Closeable> iterable) {
        if (iterable != null) {
            for (Closeable closeable : iterable) {
                IOUtils.close(closeable);
            }
        }
    }

    public static void flush(Flushable flushable) {
        FileUtils.flush(flushable);
    }

    public static void close(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                IOUtils.close(socket.getInputStream());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                IOUtils.close(socket.getOutputStream());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(ServerSocket serverSocket) {
        if (serverSocket != null) {
            try {
                serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(Deflater deflater) {
        if (deflater != null) {
            deflater.end();
        }
    }

    public static void close(Inflater inflater) {
        if (inflater != null) {
            inflater.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] deflate(byte[] byArray) {
        byte[] byArray2;
        DeflaterOutputStream deflaterOutputStream = null;
        Deflater deflater = null;
        try {
            deflater = new Deflater();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, deflater);
            ((OutputStream)deflaterOutputStream).write(byArray, 0, byArray.length);
            ((OutputStream)deflaterOutputStream).close();
            byArray2 = byteArrayOutputStream.toByteArray();
            IOUtils.close(deflaterOutputStream);
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
            byte[] byArray3 = null;
            return byArray3;
        }
        finally {
            IOUtils.close(deflaterOutputStream);
            IOUtils.close(deflater);
        }
        IOUtils.close(deflater);
        return byArray2;
    }

    public static byte[] inflate(byte[] byArray) throws IOException {
        byte[] byArray2;
        InflaterInputStream inflaterInputStream = null;
        Inflater inflater = null;
        try {
            int n;
            inflater = new Inflater();
            inflaterInputStream = new InflaterInputStream(new ByteArrayInputStream(byArray), inflater);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray3 = new byte[64];
            while ((n = ((InputStream)inflaterInputStream).read(byArray3, 0, byArray3.length)) != -1) {
                byteArrayOutputStream.write(byArray3, 0, n);
            }
            byArray2 = byteArrayOutputStream.toByteArray();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            try {
                throw new IOException(outOfMemoryError.getMessage());
            }
            catch (Throwable throwable) {
                IOUtils.close(inflaterInputStream);
                IOUtils.close(inflater);
                throw throwable;
            }
        }
        IOUtils.close(inflaterInputStream);
        IOUtils.close(inflater);
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFully(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            int n;
            byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return byArray2;
        }
        finally {
            IOUtils.close(byteArrayOutputStream);
            IOUtils.close(inputStream);
        }
    }

    static {
        for (ErrorType errorType : ErrorType.values()) {
            errorDescs.put(errorType, new EnumMap(DetailErrorType.class));
        }
        errorDescs.get((Object)ErrorType.GENERIC).put(DetailErrorType.DISK_FULL, I18nMarker.marktr("LimeWire was unable to write a necessary file because your hard drive is full. To continue using LimeWire you must free up space on your hard drive."));
        errorDescs.get((Object)ErrorType.GENERIC).put(DetailErrorType.FILE_LOCKED, I18nMarker.marktr("LimeWire was unable to open a necessary file because another program has locked the file. LimeWire may act unexpectedly until this file is released."));
        errorDescs.get((Object)ErrorType.GENERIC).put(DetailErrorType.NO_PRIVS, I18nMarker.marktr("LimeWire was unable to write a necessary file because you do not have the necessary permissions. Your preferences may not be maintained the next time you start LimeWire, or LimeWire may behave in unexpected ways."));
        errorDescs.get((Object)ErrorType.GENERIC).put(DetailErrorType.BAD_CHARS, I18nMarker.marktr("LimeWire cannot open a necessary file because the filename contains characters which are not supported by your operating system. LimeWire may behave in unexpected ways."));
        errorDescs.get((Object)ErrorType.DOWNLOAD).put(DetailErrorType.DISK_FULL, I18nMarker.marktr("LimeWire cannot download the selected file because your hard drive is full. To download more files, you must free up space on your hard drive."));
        errorDescs.get((Object)ErrorType.DOWNLOAD).put(DetailErrorType.FILE_LOCKED, I18nMarker.marktr("LimeWire was unable to download the selected file because another program is using the file. Please close the other program and retry the download."));
        errorDescs.get((Object)ErrorType.DOWNLOAD).put(DetailErrorType.NO_PRIVS, I18nMarker.marktr("LimeWire was unable to create or continue writing an incomplete file for the selected download because you do not have permission to write files to the incomplete folder. To continue using LimeWire, please choose a different Save Folder."));
        errorDescs.get((Object)ErrorType.DOWNLOAD).put(DetailErrorType.BAD_CHARS, I18nMarker.marktr("LimeWire was unable to open the incomplete file for the selected download because the filename contains characters which are not supported by your operating system."));
        for (ErrorType errorType : ErrorType.values()) {
            assert (errorDescs.get((Object)errorType) != null);
            assert (errorDescs.get((Object)errorType).size() == DetailErrorType.values().length);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DetailErrorType {
        DISK_FULL,
        FILE_LOCKED,
        NO_PRIVS,
        BAD_CHARS;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ErrorType {
        GENERIC,
        DOWNLOAD;

    }
}

