/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.io;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.limewire.io.Connectable;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortImpl;

public class ConnectableImpl
implements Connectable {
    private final IpPort ipPort;
    private final boolean tlsCapable;

    public ConnectableImpl(IpPort ipPort, boolean bl) {
        this.ipPort = ipPort;
        this.tlsCapable = bl;
    }

    public ConnectableImpl(InetSocketAddress inetSocketAddress, boolean bl) {
        this(new IpPortImpl(inetSocketAddress), bl);
    }

    public ConnectableImpl(String string, int n, boolean bl) throws UnknownHostException {
        this(new IpPortImpl(string, n), bl);
    }

    public ConnectableImpl(Connectable connectable) {
        this(new IpPortImpl(connectable.getInetSocketAddress(), connectable.getAddress()), connectable.isTLSCapable());
    }

    public boolean isTLSCapable() {
        return this.tlsCapable;
    }

    public String getAddress() {
        return this.ipPort.getAddress();
    }

    public InetAddress getInetAddress() {
        return this.ipPort.getInetAddress();
    }

    public int getPort() {
        return this.ipPort.getPort();
    }

    public InetSocketAddress getInetSocketAddress() {
        return this.ipPort.getInetSocketAddress();
    }

    public String toString() {
        return this.ipPort + ", tlsCapable: " + this.tlsCapable;
    }
}

