/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.inspection;

import com.google.inject.Injector;
import com.google.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.limewire.inspection.Inspectable;
import org.limewire.inspection.InspectableContainer;
import org.limewire.inspection.InspectableForSize;
import org.limewire.inspection.InspectablePrimitive;
import org.limewire.inspection.InspectionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InspectionUtils {
    public static Object inspectValue(String string, Injector injector) throws InspectionException {
        try {
            ArrayList<Annotation> arrayList = new ArrayList<Annotation>();
            return InspectionUtils.inspect(InspectionUtils.getTargetObject(string, arrayList, injector), arrayList);
        }
        catch (Throwable throwable) {
            if (throwable instanceof InspectionException) {
                throw (InspectionException)throwable;
            }
            throw new InspectionException(throwable);
        }
    }

    private static Object getTargetObject(String string, List<Annotation> list, Injector injector) throws Throwable {
        Object object;
        StringTokenizer stringTokenizer;
        if (string.contains(":")) {
            return InspectionUtils.getTargetStaticObject(string, list);
        }
        Class<?> clazz = null;
        Class<?> clazz2 = null;
        if (string.contains("|")) {
            stringTokenizer = new StringTokenizer(string, "|");
            clazz = Class.forName(stringTokenizer.nextToken());
            string = stringTokenizer.nextToken();
        }
        if ((stringTokenizer = new StringTokenizer(string, ",")).countTokens() < 2) {
            throw new InspectionException();
        }
        Class<?> clazz3 = Class.forName(stringTokenizer.nextToken());
        if (clazz != null) {
            clazz2 = clazz3;
            if (clazz3.getEnclosingClass() == null) {
                throw new InspectionException("must be a container!");
            }
            if (!clazz.isAssignableFrom(clazz3.getEnclosingClass())) {
                throw new InspectionException("wrong container!");
            }
        } else {
            clazz2 = clazz3;
            if (clazz3.getEnclosingClass() != null) {
                clazz = clazz3.getEnclosingClass();
            }
        }
        if (clazz == null) {
            if (clazz2.getAnnotation(Singleton.class) == null && !clazz2.isInterface()) {
                throw new InspectionException("must have singleton annotation or be interface!");
            }
            object = injector.getInstance(clazz2);
        } else {
            if (clazz.getAnnotation(Singleton.class) == null && !clazz.isInterface()) {
                throw new InspectionException("lookup class must be singleton or interface!");
            }
            if (clazz2.getAnnotation(InspectableContainer.class) == null) {
                throw new InspectionException("container must be annotated with InspectableContainer");
            }
            Object object2 = injector.getInstance(clazz);
            Constructor<?>[] constructorArray = clazz2.getDeclaredConstructors();
            if (constructorArray.length != 1) {
                throw new InspectionException("wrong constructors length: " + constructorArray.length);
            }
            Class<?>[] classArray = constructorArray[0].getParameterTypes();
            if (classArray.length != 1 || !clazz.isAssignableFrom(classArray[0])) {
                throw new InspectionException("wrong parameter count or type for constructor");
            }
            constructorArray[0].setAccessible(true);
            object = constructorArray[0].newInstance(object2);
        }
        while (stringTokenizer.hasMoreTokens()) {
            object = InspectionUtils.getValue(object, stringTokenizer.nextToken(), list);
        }
        return object;
    }

    private static Object getTargetStaticObject(String string, List<Annotation> list) throws Throwable {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":,");
        if (stringTokenizer.countTokens() < 2) {
            throw new InspectionException();
        }
        Object object = InspectionUtils.getValue(Class.forName(stringTokenizer.nextToken()), stringTokenizer.nextToken(), list);
        while (stringTokenizer.hasMoreTokens()) {
            object = InspectionUtils.getValue(object, stringTokenizer.nextToken(), list);
        }
        return object;
    }

    private static Object inspect(Object object, List<Annotation> list) throws Exception {
        if (object instanceof Inspectable) {
            Inspectable inspectable = (Inspectable)object;
            return inspectable.inspect();
        }
        for (Annotation annotation : list) {
            if (annotation instanceof InspectablePrimitive) {
                return String.valueOf(object);
            }
            if (!(annotation instanceof InspectableForSize)) continue;
            Method method = object.getClass().getMethod("size", new Class[0]);
            method.setAccessible(true);
            return method.invoke(object, new Object[0]).toString();
        }
        throw new InspectionException();
    }

    private static Object getValue(Object object, String string, List<Annotation> list) throws IllegalAccessException, NoSuchFieldException {
        Field field = object instanceof Class ? InspectionUtils.getFieldImpl((Class)object, string) : InspectionUtils.getFieldImpl(object.getClass(), string);
        field.setAccessible(true);
        if (list != null) {
            list.clear();
            for (Annotation annotation : field.getAnnotations()) {
                list.add(annotation);
            }
        }
        return field.get(object);
    }

    private static Field getFieldImpl(Class clazz, String string) throws NoSuchFieldException {
        if (clazz == null) {
            throw new NoSuchFieldException("Invalid field : " + string);
        }
        try {
            return clazz.getDeclaredField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return InspectionUtils.getFieldImpl(clazz.getSuperclass(), string);
        }
    }
}

