/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.http.reactor;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import org.apache.http.impl.nio.DefaultClientIOEventDispatch;
import org.apache.http.impl.nio.reactor.SessionRequestImpl;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOReactorStatus;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.reactor.SessionRequest;
import org.apache.http.nio.reactor.SessionRequestCallback;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.limewire.http.reactor.HttpChannel;
import org.limewire.http.reactor.HttpIOSession;
import org.limewire.net.SocketsManager;
import org.limewire.nio.AbstractNBSocket;
import org.limewire.nio.NBSocket;
import org.limewire.nio.observer.ConnectObserver;

public class LimeConnectingIOReactor
implements ConnectingIOReactor {
    public static final String IO_SESSION_KEY = "org.limewire.iosession";
    private final HttpParams params;
    protected volatile IOEventDispatch eventDispatch = null;
    private final Executor ioExecutor;
    private final SocketsManager socketsManager;
    private static final String NHTTP_CONN = "NHTTP_CONN";

    public LimeConnectingIOReactor(HttpParams httpParams, Executor executor, SocketsManager socketsManager) {
        if (httpParams == null) {
            throw new IllegalArgumentException();
        }
        this.params = httpParams;
        this.ioExecutor = executor;
        this.socketsManager = socketsManager;
    }

    public void execute(IOEventDispatch iOEventDispatch) throws IOException {
        if (!(iOEventDispatch instanceof DefaultClientIOEventDispatch)) {
            throw new IllegalArgumentException("Event dispatch must be of type DefaultClientIOEventDispatch");
        }
        this.eventDispatch = iOEventDispatch;
    }

    public SessionRequest connect(SocketAddress socketAddress, SocketAddress socketAddress2, final Object object, SessionRequestCallback sessionRequestCallback) {
        final SessionRequestImpl sessionRequestImpl = new SessionRequestImpl(socketAddress, socketAddress2, object, sessionRequestCallback);
        sessionRequestImpl.setConnectTimeout(HttpConnectionParams.getConnectionTimeout((HttpParams)this.params));
        try {
            NBSocket nBSocket = (NBSocket)this.socketsManager.create(SocketsManager.ConnectType.PLAIN);
            this.socketsManager.connect(nBSocket, (InetSocketAddress)socketAddress2, (InetSocketAddress)socketAddress, sessionRequestImpl.getConnectTimeout(), new ConnectObserver(){

                public void handleConnect(Socket socket) throws IOException {
                    LimeConnectingIOReactor.this.prepareSocket((AbstractNBSocket)socket, object, sessionRequestImpl);
                }

                public void handleIOException(IOException iOException) {
                    sessionRequestImpl.failed(iOException);
                }

                public void shutdown() {
                    sessionRequestImpl.failed(new IOException("couldn't connect"));
                }
            }, SocketsManager.ConnectType.PLAIN);
        }
        catch (IOException iOException) {
            sessionRequestImpl.failed(iOException);
        }
        return sessionRequestImpl;
    }

    protected void prepareSocket(AbstractNBSocket abstractNBSocket, Object object, SessionRequestImpl sessionRequestImpl) throws IOException {
        abstractNBSocket.setTcpNoDelay(HttpConnectionParams.getTcpNoDelay((HttpParams)this.params));
        int n = HttpConnectionParams.getLinger((HttpParams)this.params);
        if (n >= 0) {
            abstractNBSocket.setSoLinger(n > 0, n);
        }
        HttpIOSession httpIOSession = new HttpIOSession(abstractNBSocket, this.ioExecutor);
        httpIOSession.setAttribute("http.session.attachment", object);
        httpIOSession.setSocketTimeout(HttpConnectionParams.getSoTimeout((HttpParams)this.params));
        HttpChannel httpChannel = new HttpChannel(httpIOSession, this.eventDispatch, null);
        httpIOSession.setHttpChannel(httpChannel);
        this.eventDispatch.connected((IOSession)httpIOSession);
        sessionRequestImpl.completed((IOSession)httpIOSession);
        NHttpConnection nHttpConnection = (NHttpConnection)httpIOSession.getAttribute(NHTTP_CONN);
        assert (nHttpConnection != null);
        nHttpConnection.getContext().setAttribute(IO_SESSION_KEY, (Object)httpIOSession);
        abstractNBSocket.setReadObserver(httpChannel);
        abstractNBSocket.setWriteObserver(httpChannel);
    }

    public IOReactorStatus getStatus() {
        throw new UnsupportedOperationException();
    }

    public void shutdown() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void shutdown(long l) throws IOException {
        throw new UnsupportedOperationException();
    }
}

