/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.http.reactor;

import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.ByteChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.reactor.SessionBufferStatus;
import org.limewire.http.reactor.HttpChannel;
import org.limewire.nio.AbstractNBSocket;
import org.limewire.nio.NIODispatcher;
import org.limewire.nio.Throttle;
import org.limewire.nio.channel.ThrottleWriter;

public class HttpIOSession
implements IOSession {
    private static final Log LOG = LogFactory.getLog(HttpIOSession.class);
    private final Map<String, Object> attributes;
    private SessionBufferStatus bufferStatus;
    private int socketTimeout;
    private AbstractNBSocket socket;
    private HttpChannel channel;
    private int eventMask;
    private ThrottleWriter throttleWriter;
    private AtomicBoolean closed = new AtomicBoolean(false);
    private final Executor ioExecutor;

    public HttpIOSession(AbstractNBSocket abstractNBSocket, Executor executor) {
        if (abstractNBSocket == null) {
            throw new IllegalArgumentException();
        }
        this.attributes = Collections.synchronizedMap(new HashMap());
        this.socketTimeout = 0;
        this.socket = abstractNBSocket;
        this.ioExecutor = executor;
    }

    public void setHttpChannel(HttpChannel httpChannel) {
        this.channel = httpChannel;
    }

    public ByteChannel channel() {
        return this.channel;
    }

    public void close() {
        if (this.closed.getAndSet(true)) {
            return;
        }
        this.channel.closeWhenBufferedOutputHasBeenFlushed();
    }

    public Object getAttribute(String string) {
        return this.attributes.get(string);
    }

    public SessionBufferStatus getBufferStatus() {
        return this.bufferStatus;
    }

    public SocketAddress getLocalAddress() {
        return this.socket.getLocalSocketAddress();
    }

    public SocketAddress getRemoteAddress() {
        return this.socket.getRemoteSocketAddress();
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public Object removeAttribute(String string) {
        return this.attributes.remove(string);
    }

    public void setAttribute(String string, Object object) {
        this.attributes.put(string, object);
    }

    public void setBufferStatus(SessionBufferStatus sessionBufferStatus) {
        this.bufferStatus = sessionBufferStatus;
    }

    public synchronized int getEventMask() {
        return this.eventMask;
    }

    public synchronized void setEventMask(int n) {
        if (this.isClosed()) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("Attempted to set event mask to " + n + " on closed session: " + this));
            }
            return;
        }
        this.eventMask = n;
        this.channel.requestRead((n & 1) != 0);
        this.channel.requestWrite((n & 4) != 0);
    }

    public synchronized void setEvent(int n) {
        if (this.isClosed()) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("Attempted to set event mask to " + n + " on closed session: " + this));
            }
            return;
        }
        this.eventMask |= n;
        if ((n & 1) != 0) {
            this.channel.requestRead(true);
        }
        if ((n & 4) != 0) {
            this.channel.requestWrite(true);
        }
    }

    public synchronized void clearEvent(int n) {
        if (this.isClosed()) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("Attempted to set event mask to " + n + " on closed session: " + this));
            }
            return;
        }
        this.eventMask &= ~n;
        if ((n & 1) != 0) {
            this.channel.requestRead(false);
        }
        if ((n & 4) != 0) {
            this.channel.requestWrite(false);
        }
    }

    public void setSocketTimeout(int n) {
        this.socketTimeout = n;
        try {
            this.socket.setSoTimeout(n);
        }
        catch (SocketException socketException) {
            LOG.warn((Object)"Could not set socket timeout", (Throwable)socketException);
        }
    }

    public boolean hasBufferedInput() {
        return this.bufferStatus != null && this.bufferStatus.hasBufferedInput();
    }

    public boolean hasBufferedOutput() {
        return this.bufferStatus != null && this.bufferStatus.hasBufferedOutput();
    }

    public void setThrottle(Throttle throttle) {
        assert (NIODispatcher.instance().isDispatchThread()) : "wrong thread: " + Thread.currentThread().getName();
        this.throttleWriter.setThrottle(throttle);
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void shutdown() {
        this.closed.set(true);
        this.socket.close();
    }

    public void setThrottleChannel(ThrottleWriter throttleWriter) {
        this.throttleWriter = throttleWriter;
    }

    public int getStatus() {
        throw new UnsupportedOperationException();
    }

    public Executor getIoExecutor() {
        return this.ioExecutor;
    }
}

