/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.http.reactor;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOSession;
import org.limewire.http.reactor.HttpIOSession;
import org.limewire.nio.channel.ChannelReadObserver;
import org.limewire.nio.channel.ChannelWriter;
import org.limewire.nio.channel.InterestReadableByteChannel;
import org.limewire.nio.channel.InterestWritableByteChannel;
import org.limewire.util.BufferUtils;

public class HttpChannel
implements ByteChannel,
ChannelReadObserver,
ChannelWriter {
    private static final Log LOG = LogFactory.getLog(HttpChannel.class);
    private final HttpIOSession session;
    private final IOEventDispatch eventDispatch;
    private AtomicBoolean closed = new AtomicBoolean(false);
    private InterestReadableByteChannel readSource;
    private volatile InterestWritableByteChannel writeSource;
    private boolean writeInterest;
    private boolean readInterest;
    private ByteBuffer methodBuffer;
    private volatile boolean pendingClose = false;

    public HttpChannel(HttpIOSession httpIOSession, IOEventDispatch iOEventDispatch, String string) {
        if (httpIOSession == null) {
            throw new IllegalArgumentException("session must not be null");
        }
        if (iOEventDispatch == null) {
            throw new IllegalArgumentException("eventDispatch must not be null");
        }
        this.session = httpIOSession;
        this.eventDispatch = iOEventDispatch;
        if (string != null) {
            this.methodBuffer = ByteBuffer.wrap(string.getBytes());
        }
    }

    public HttpChannel(HttpIOSession httpIOSession, IOEventDispatch iOEventDispatch) {
        this(httpIOSession, iOEventDispatch, null);
    }

    public int read(ByteBuffer byteBuffer) throws IOException {
        if (this.methodBuffer != null) {
            int n = BufferUtils.transfer(this.methodBuffer, byteBuffer, false);
            if (this.methodBuffer.hasRemaining()) {
                return n;
            }
            this.methodBuffer = null;
            return n + this.readSource.read(byteBuffer);
        }
        return this.readSource.read(byteBuffer);
    }

    public void close() throws IOException {
        this.shutdown();
    }

    public void closeWhenBufferedOutputHasBeenFlushed() {
        InterestWritableByteChannel interestWritableByteChannel = this.writeSource;
        if (interestWritableByteChannel != null) {
            if (!interestWritableByteChannel.hasBufferedOutput()) {
                this.session.shutdown();
            } else {
                this.pendingClose = true;
                this.requestWrite(true);
            }
        } else {
            this.session.shutdown();
        }
    }

    public boolean isOpen() {
        return !this.closed.get();
    }

    public int write(ByteBuffer byteBuffer) throws IOException {
        return this.writeSource.write(byteBuffer);
    }

    public void handleRead() throws IOException {
        if (!this.readInterest) {
            LOG.error((Object)"Unexpected call to HttpChannel.handleRead(), turning read interest back off");
            this.readSource.interestRead(false);
            return;
        }
        this.eventDispatch.inputReady((IOSession)this.session);
    }

    public void handleIOException(IOException iOException) {
        LOG.error((Object)"Unexpected exception", (Throwable)iOException);
    }

    public void shutdown() {
        if (!this.closed.getAndSet(true)) {
            this.session.getIoExecutor().execute(new Runnable(){

                public void run() {
                    HttpChannel.this.eventDispatch.disconnected((IOSession)HttpChannel.this.session);
                }
            });
        }
    }

    public InterestReadableByteChannel getReadChannel() {
        return this.readSource;
    }

    public void setReadChannel(InterestReadableByteChannel interestReadableByteChannel) {
        this.readSource = interestReadableByteChannel;
        if (this.readSource != null) {
            this.readSource.interestRead(this.readInterest);
        }
    }

    public synchronized InterestWritableByteChannel getWriteChannel() {
        return this.writeSource;
    }

    public synchronized void setWriteChannel(InterestWritableByteChannel interestWritableByteChannel) {
        this.writeSource = interestWritableByteChannel;
        if (this.writeSource != null) {
            this.writeSource.interestWrite(this, this.writeInterest);
        }
    }

    public boolean handleWrite() throws IOException {
        if (this.pendingClose) {
            if (!this.writeSource.hasBufferedOutput()) {
                this.session.shutdown();
            }
            return false;
        }
        if (!this.writeInterest) {
            return false;
        }
        this.eventDispatch.outputReady((IOSession)this.session);
        return this.session.hasBufferedOutput();
    }

    public void requestRead(boolean bl) {
        if (this.pendingClose) {
            return;
        }
        this.readInterest = bl;
        if (this.readSource != null) {
            this.readSource.interestRead(bl);
        }
    }

    public void requestWrite(boolean bl) {
        if (this.pendingClose) {
            bl = true;
        }
        this.writeInterest = bl;
        if (this.writeSource != null) {
            this.writeSource.interestWrite(this, bl);
        }
    }

    public boolean isWriteInterest() {
        return this.writeInterest;
    }

    public boolean isReadInterest() {
        return this.readInterest;
    }
}

